/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.EmptyWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ImageInterfaceWidget;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.crop.BlockEntityMultiCrop;
import com.denfop.containermenu.ContainerMenuMultiCrop;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.IFluidTank;

public class ScreenMultiCrop<T extends ContainerMenuMultiCrop>
extends ScreenMain<ContainerMenuMultiCrop> {
    public ScreenMultiCrop(ContainerMenuMultiCrop guiContainer) {
        super(guiContainer);
        this.imageWidth += 40;
        this.imageHeight += 40;
        this.inventory.addY(40);
        this.inventory.setX(this.inventory.getX() + 20);
        this.addWidget(new ImageInterfaceWidget(this, 0, 0, this.imageWidth, this.imageHeight));
        this.addWidget(TankWidget.createNormal(this, 5, 122, (IFluidTank)((BlockEntityMultiCrop)guiContainer.base).fluidWaterTank));
        this.addWidget(TankWidget.createNormal(this, this.imageWidth - 25, 122, (IFluidTank)((BlockEntityMultiCrop)guiContainer.base).fluidPestTank));
        int totalSlots = ((BlockEntityMultiCrop)guiContainer.base).place.length;
        int centerX = 99;
        int slotSpacing = 40;
        int i = 0;
        while (i < ((BlockEntityMultiCrop)guiContainer.base).upBlockSlot.size()) {
            int xDisplayPosition1 = centerX - (totalSlots - 1) * slotSpacing / 2 + i * slotSpacing;
            this.addComponent(new ScreenWidget(this, xDisplayPosition1 + 2, 56, EnumTypeComponent.FLUID_PART6, new WidgetDefault<EmptyWidget>(new EmptyWidget())));
            int finalI = i++;
            this.addWidget(new TooltipWidget(this, xDisplayPosition1 + 2, 56, 13, 17).withTooltip((Supplier<String>)((Supplier)() -> {
                if (((BlockEntityMultiCrop)guiContainer.base).maxTickSoil[finalI] != 0) {
                    return ModUtils.getString((double)((BlockEntityMultiCrop)guiContainer.base).tickSoil[finalI] * 100.0 / (double)((BlockEntityMultiCrop)guiContainer.base).maxTickSoil[finalI]) + "%";
                }
                return "0%";
            })));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        String name = Localization.translate(((BlockEntityMultiCrop)((ContainerMenuMultiCrop)this.container).base).getName());
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        pose.scale(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.imageWidth / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 6) / scale);
        this.draw(poseStack, name, textX, textY, 0x404040);
        pose.popPose();
    }
}

