/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.ButtonWidget;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.mechanism.BlockEntityModuleMachine;
import com.denfop.containermenu.ContainerMenuModuleMachine;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenModuleMachine<T extends ContainerMenuModuleMachine>
extends ScreenMain<ContainerMenuModuleMachine> {
    public final ContainerMenuModuleMachine container;

    public ScreenModuleMachine(ContainerMenuModuleMachine container1) {
        super(container1);
        this.container = container1;
        this.imageHeight = 178;
        this.inventory.setX(7);
        this.inventory.setY(96);
        this.addWidget(new ButtonWidget(this, 103, 15, 68, 14, (BlockEntityBase)((Object)container1.base), 0, Localization.translate("button.write")));
    }

    private static List<String> getInformation() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(Localization.translate("iu.moduleinformation1"));
        ret.add(Localization.translate("iu.moduleinformation2"));
        ret.add(Localization.translate("iu.moduleinformation3"));
        return ret;
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft(), this.guiTop(), 0, 0, this.imageWidth, this.imageHeight);
        String name = Localization.translate(((BlockEntityModuleMachine)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.imageHeight / 2, 4, (Component)Component.literal((String)name), 0x404040, false);
    }

    @Override
    protected void renderBg(GuiGraphics poseStack, float f, int x, int y) {
        super.renderBg(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xoffset = (this.width - this.imageWidth) / 2;
        int yoffset = (this.height - this.imageHeight) / 2;
        this.bindTexture();
        ScreenModuleMachine.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        this.bindTexture();
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.moduleinformation"));
            List<String> compatibleUpgrades = ScreenModuleMachine.getInformation();
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine_main1.png");
    }
}

