/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.TankWidget;
import com.denfop.blockentity.gaswell.BlockEntityGasWellTank;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuGasWellTank;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class ScreenGasWellTank<T extends ContainerMenuGasWellTank>
extends ScreenMain<ContainerMenuGasWellTank> {
    public ScreenGasWellTank(final ContainerMenuGasWellTank guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.addWidget(new TankWidget(this, this, 75, 13, 26, 61, (IFluidTank)((BlockEntityGasWellTank)guiContainer.base).getTank()){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                FluidStack fs = ((BlockEntityGasWellTank)guiContainer.base).getTank().getFluid();
                if (Keyboard.isKeyDown(340)) {
                    if (this.tank instanceof Fluids.InternalFluidTank) {
                        Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                        ret.add(Localization.translate("iu.tank.fluids"));
                        ret.addAll(tank1.getFluidList());
                    }
                } else if (!fs.isEmpty() && fs.getAmount() > 0) {
                    Fluid fluid = fs.getFluid();
                    if (fluid != null) {
                        ret.add(fluid.getFluidType().getDescription().getString() + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                    } else {
                        ret.add("invalid fluid stack");
                    }
                } else {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                }
                return ret;
            }

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                FluidStack fs = ((BlockEntityGasWellTank)guiContainer.base).getTank().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    fluidX += 3;
                    fluidY += 3;
                    int fluidWidth = 20;
                    int fluidHeight = 55;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.gui.bindTexture();
                    this.gui.drawTexturedModalRect(poseStack, this.gui.guiLeft + 97, this.gui.guiTop + 14, 191, 5, 7, 46);
                }
            }
        });
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guigaswell_tank.png");
    }
}

