/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.vein.gas.TypeGas;
import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.gaswell.BlockEntityGasWellController;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuGasWellController;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class ScreenGasWellController<T extends ContainerMenuGasWellController>
extends ScreenMain<ContainerMenuGasWellController> {
    boolean hoverController = false;

    public ScreenGasWellController(final ContainerMenuGasWellController guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.componentList.add(new ScreenWidget(this, 7, 64, EnumTypeComponent.ENERGY, new WidgetDefault<Energy>(((BlockEntityGasWellController)guiContainer.base).getEnergy())));
        this.addWidget(new TankWidget(this, this, 75, 13, 26, 61, (IFluidTank)((BlockEntityGasWellController)guiContainer.base).tank.getTank()){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                FluidStack fs = ((BlockEntityGasWellController)guiContainer.base).tank.getTank().getFluid();
                if (Keyboard.isKeyDown(340)) {
                    if (this.tank instanceof Fluids.InternalFluidTank) {
                        Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                        ret.add(Localization.translate("iu.tank.fluids"));
                        ret.addAll(tank1.getFluidList());
                    }
                } else if (!fs.isEmpty() && fs.getAmount() > 0) {
                    Fluid fluid = fs.getFluid();
                    if (fluid != null) {
                        ret.add(fluid.getFluidType().getDescription().getString() + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                    } else {
                        ret.add("invalid fluid stack");
                    }
                } else {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                }
                return ret;
            }

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                FluidStack fs = ((BlockEntityGasWellController)guiContainer.base).tank.getTank().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    fluidX += 3;
                    fluidY += 3;
                    int fluidWidth = 20;
                    int fluidHeight = 55;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.gui.bindTexture();
                    this.gui.drawTexturedModalRect(poseStack, this.gui.guiLeft + 97, this.gui.guiTop + 14, 191, 5, 7, 46);
                }
            }
        });
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("quarry.guide.gas_well"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 7; ++i) {
                compatibleUpgrades.add(Localization.translate("quarry.guide.gas_well" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (this.hoverController) {
            new PacketUpdateServerTile((BlockEntity)((ContainerMenuGasWellController)this.container).base, 0.0);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.hoverController = false;
        if (par1 >= 122 && par2 >= 32 && par1 <= 142 && par2 <= 52) {
            this.hoverController = true;
            new AdvancedTooltipWidget(this, 122, 32, 142, 52).withTooltip(((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).work ? Localization.translate("turn_off") : Localization.translate("turn_on")).drawForeground(poseStack, par1, par2);
        }
        if (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein != null && ((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.isFind() && ((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getType() != TypeGas.NONE) {
            String text = "";
            if (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getType() == TypeGas.IODINE) {
                text = Localization.translate(((IUFluid)((Object)FluidName.fluidiodine.getInstance().get())).getFluidType().getDescriptionId());
            }
            if (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getType() == TypeGas.BROMIDE) {
                text = Localization.translate(((IUFluid)((Object)FluidName.fluidbromine.getInstance().get())).getFluidType().getDescriptionId());
            }
            if (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getType() == TypeGas.CHLORINE) {
                text = Localization.translate(((IUFluid)((Object)FluidName.fluidchlorum.getInstance().get())).getFluidType().getDescriptionId());
            }
            if (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getType() == TypeGas.FLORINE) {
                text = Localization.translate(((IUFluid)((Object)FluidName.fluidfluor.getInstance().get())).getFluidType().getDescriptionId());
            }
            new AdvancedTooltipWidget(this, 34, 36, 48, 50).withTooltip(text + " " + ((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getCol() + "/" + ((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getMaxCol() + "mb").drawForeground(poseStack, par1, par2);
        }
    }

    @Override
    protected void drawBackground(GuiGraphics poseStack) {
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.componentList.forEach(guiComponent -> guiComponent.drawBackground(poseStack, this.guiLeft(), this.guiTop()));
        this.bindTexture();
        if (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).work) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 122, this.guiTop + 32, 235, 64, 21, 21);
        }
        if (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein != null && ((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.isFind() && ((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getType() != TypeGas.NONE) {
            int x1 = 0;
            int y1 = 0;
            switch (((BlockEntityGasWellController)((ContainerMenuGasWellController)this.container).base).vein.getType()) {
                case CHLORINE: {
                    x1 = 241;
                    y1 = 16;
                    break;
                }
                case BROMIDE: {
                    x1 = 241;
                    y1 = 0;
                    break;
                }
                case FLORINE: {
                    x1 = 241;
                    y1 = 36;
                    break;
                }
                default: {
                    x1 = 241;
                    y1 = 48;
                }
            }
            this.drawTexturedModalRect(poseStack, this.guiLeft + 34, this.guiTop + 36, x1, y1, 15, 16);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenGasWellController.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, 10, 10);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawBackgroundAndTitle(poseStack, partialTicks, mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guigaswell_controller.png");
    }
}

