/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.api.widget.TankWidget;
import com.denfop.blockentity.gasturbine.BlockEntityGasTurbineController;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuGasTurbineController;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;

public class ScreenGasTurbine<T extends ContainerMenuGasTurbineController>
extends ScreenMain<ContainerMenuGasTurbineController> {
    boolean hoverButton;

    public ScreenGasTurbine(ContainerMenuGasTurbineController guiContainer) {
        super(guiContainer);
        this.componentList.clear();
        this.addWidget(new TankWidget(this, 69, 5, 37, 58, (IFluidTank)((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)this.container).base).tank.getTank()){

            @Override
            protected List<String> getToolTip() {
                ArrayList<String> ret = new ArrayList<String>();
                FluidStack fs = ((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)ScreenGasTurbine.this.container).base).tank.getTank().getFluid();
                if (Keyboard.isKeyDown(340)) {
                    if (this.tank instanceof Fluids.InternalFluidTank) {
                        Fluids.InternalFluidTank tank1 = (Fluids.InternalFluidTank)this.tank;
                        ret.add(Localization.translate("iu.tank.fluids"));
                        ret.addAll(tank1.getFluidList());
                    }
                } else if (!fs.isEmpty() && fs.getAmount() > 0) {
                    Fluid fluid = fs.getFluid();
                    if (fluid != null) {
                        ret.add(fluid.getFluidType().getDescription().getString() + ": " + fs.getAmount() + " " + Localization.translate("iu.generic.text.mb"));
                    } else {
                        ret.add("invalid fluid stack");
                    }
                } else {
                    ret.add(Localization.translate("iu.generic.text.empty"));
                }
                return ret;
            }

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                FluidStack fs = ((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)ScreenGasTurbine.this.container).base).tank.getTank().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x;
                    int fluidY = this.y;
                    fluidX += 8;
                    fluidY += 12;
                    int fluidWidth = 23;
                    int fluidHeight = 41;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    double renderHeight = (double)fluidHeight * ModUtils.limit((double)fs.getAmount() / (double)this.tank.getCapacity(), 0.0, 1.0);
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)mouseY + (double)(fluidY + fluidHeight) - renderHeight, fluidWidth, renderHeight, sprite, color, 1.0, false, true);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.gui.bindTexture();
                    this.gui.drawTexturedModalRect(poseStack, this.gui.guiLeft + 97, this.gui.guiTop + 21, 208, 4, 7, 46);
                }
            }
        });
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("quarry.guide.gasturbine"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 4; ++i) {
                compatibleUpgrades.add(Localization.translate("quarry.guide.gasturbine" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 120, mouseY, text);
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        if (this.hoverButton) {
            new PacketUpdateServerTile((BlockEntity)((ContainerMenuGasTurbineController)this.container).base, 0.0);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.hoverButton = false;
        if (par1 >= 7 && par2 >= 39 && par1 <= 28 && par2 <= 61) {
            this.hoverButton = true;
        }
        new AdvancedTooltipWidget(this, 7, 65, 168, 79).withTooltip(ModUtils.getString(Math.min(((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)this.container).base).energy.getEnergy().getEnergy(), ((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)this.container).base).energy.getEnergy().getCapacity())) + "/" + ModUtils.getString(((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)this.container).base).energy.getEnergy().getCapacity()) + " EF").drawForeground(poseStack, par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        poseStack.blit(currentTexture, this.getGuiLeft(), this.getGuiTop(), 0, 0, this.getXSize(), this.getYSize());
        String name = ((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)this.container).base).getDisplayName().getString();
        int textWidth = this.getStringWidth(name);
        float scale = 1.0f;
        if (textWidth > 120) {
            scale = 120.0f / (float)textWidth;
        }
        PoseStack pose = poseStack.pose();
        pose.pushPose();
        pose.scale(scale, scale, 1.0f);
        int centerX = this.guiLeft + this.imageWidth / 2;
        int textX = (int)((float)centerX / scale - (float)textWidth / 2.0f);
        int textY = (int)((float)(this.guiTop + 3) / scale);
        poseStack.drawString(Minecraft.getInstance().font, name, textX, textY, 0x404040, false);
        pose.scale(1.0f / scale, 1.0f / scale, 1.0f);
        pose.popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenGasTurbine.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, 10, 10);
        this.bindTexture();
        if (this.hoverButton) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 7, this.guiTop + 39, 234, 0, 23, 23);
        }
        if (((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)this.container).base).work) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 7, this.guiTop + 39, 234, 24, 22, 23);
        }
        this.drawTexturedModalRect(poseStack, this.guiLeft + 11, this.guiTop + 69, 11, 172, (int)(((BlockEntityGasTurbineController)((ContainerMenuGasTurbineController)this.container).base).energy.getEnergy().getFillRatio() * 154.0), 8);
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guigas_turbine.png");
    }
}

