/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.space.IBody;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.api.space.rovers.api.IRovers;
import com.denfop.api.widget.ScrollDirection;
import com.denfop.api.widget.TooltipWidget;
import com.denfop.blockentity.mechanism.BlockEntityResearchTableSpace;
import com.denfop.containermenu.ContainerMenuResearchTableSpace;
import com.denfop.network.packet.PacketChangeSpaceOperation;
import com.denfop.network.packet.PacketReturnRoversToPlanet;
import com.denfop.network.packet.PacketSendRoversToPlanet;
import com.denfop.screen.ScreenDefaultResearchTable;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenResearchTableSpace;
import com.denfop.sound.EnumSound;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class ScreenExpeditionTableSpace
extends ScreenDefaultResearchTable {
    boolean hoverDelete;
    boolean hoverSend;
    boolean hoverBack;
    boolean hoverAuto;

    public ScreenExpeditionTableSpace(ScreenResearchTableSpace tileEntityResearchTableSpace) {
        super(tileEntityResearchTableSpace, 25, 25, 150, 150);
    }

    @Override
    public void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        IFakeBody fakeBody;
        super.drawForegroundLayer(poseStack, par1, par2);
        this.hoverDelete = false;
        this.hoverSend = false;
        this.hoverBack = false;
        this.hoverAuto = false;
        int guiLeft = this.x + this.offsetX1;
        int guiTop = this.y + this.offsetY1;
        if (par1 >= guiLeft + this.width - 20 && par2 <= guiLeft + this.width - 20 + 15 && par2 >= guiTop + 5 && par2 <= guiTop + 20) {
            this.hoverDelete = true;
        }
        if ((fakeBody = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.getTile().container).base).fakeBody) == null) {
            if (par1 >= guiLeft + 30 + 7 && (double)par2 <= (double)(guiLeft + 30 + 7) + 77.25 && par2 >= guiTop + 55 && (double)par2 <= (double)(guiTop + 55) + 15.0) {
                this.hoverSend = true;
            }
        } else {
            IRovers rover = fakeBody.getRover();
            int fluid = rover.getItem().getFluidHandler(rover.getItemStack()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).getAmount();
            double energy = ElectricItem.manager.getCharge(rover.getItemStack());
            if (fakeBody.getTimerTo().canWork()) {
                new TooltipWidget(this.tile, (int)((double)guiLeft + ((double)(this.width / 2) - 59.625)), guiTop + 25, 119, 12).withTooltip("\u041b\u0435\u0442\u0438\u0442\n\u0412\u0440\u0435\u043c\u044f: " + fakeBody.getTimerTo().getDisplay() + "\n\u0416\u0438\u0434\u043a\u043e\u0441\u0442\u044c: " + fluid + "mb \n\u042d\u043d\u0435\u0440\u0433\u0438\u044f: " + ModUtils.getString(energy) + "EF").drawForeground(poseStack, par1, par2);
            }
            if (fakeBody.getTimerFrom().canWork()) {
                new TooltipWidget(this.tile, (int)((double)guiLeft + ((double)(this.width / 2) - 59.625)), guiTop + 25, 119, 12).withTooltip("\u0412\u043e\u0437\u0432\u0440\u0430\u0449\u0430\u0435\u0442\u0441\u044f\n\u0412\u0440\u0435\u043c\u044f: " + fakeBody.getTimerFrom().getDisplay() + "\n\u0416\u0438\u0434\u043a\u043e\u0441\u0442\u044c: " + fluid + "mb \n\u042d\u043d\u0435\u0440\u0433\u0438\u044f: " + ModUtils.getString(energy) + "EF").drawForeground(poseStack, par1, par2);
            }
            if (par1 >= guiLeft + 30 + 7 && (double)par2 <= (double)(guiLeft + 30 + 7) + 77.25 && par2 >= guiTop + 55 && (double)par2 <= (double)(guiTop + 55) + 15.0) {
                this.hoverBack = true;
            }
            if (par1 >= guiLeft + 30 + 7 && (double)par2 <= (double)(guiLeft + 30 + 7) + 77.25 && par2 >= guiTop + 35 + 55 && (double)par2 <= (double)(guiTop + 35 + 55) + 15.0) {
                this.hoverAuto = true;
            }
        }
    }

    @Override
    public void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(poseStack, partialTicks, mouseX, mouseY);
        this.getTile().drawString(poseStack, Localization.translate("iu.space.expedition.title"), this.getTile().guiLeft + this.x + this.offsetX1 + this.width / 2 - this.tile.getStringWidth(Localization.translate("iu.space.expedition.title")) / 2, this.getTile().guiTop + this.y + this.offsetY1 + 5, ModUtils.convertRGBAcolorToInt(255, 255, 255));
        IBody planet = this.getTile().focusedPlanet;
        PoseStack pose = poseStack.pose();
        int guiLeft = this.getTile().guiLeft + this.x + this.offsetX1;
        int guiTop = this.getTile().guiTop + this.y + this.offsetY1;
        pose.pushPose();
        pose.translate((float)(guiLeft + this.width - 20), (float)(guiTop + 5), 20.0f);
        ScreenIndustrialUpgrade.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"));
        pose.scale(0.5f, 0.5f, 1.0f);
        if (!this.hoverDelete) {
            this.getTile().drawTexturedModalRect(poseStack, 0, 0, 139, 32, 30, 30);
        } else {
            this.getTile().drawTexturedModalRect(poseStack, 0, 0, 170, 32, 30, 30);
        }
        pose.popPose();
        Data data = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).base).dataMap.get(planet);
        IFakeBody fakeBody = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)this.getTile().container).base).fakeBody;
        if (fakeBody == null) {
            SpaceOperation spaceOperation = ((BlockEntityResearchTableSpace)((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).base).getSpaceBody().get(this.getTile().focusedPlanet);
            if (spaceOperation == null) {
                this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other2.png"), (int)((double)(guiLeft + this.width / 2) - 59.625), guiTop + 25, 20.0f, 0.75f, 0.75f, 0, 34, 159, 16);
                this.getTile().drawCenteredText(poseStack, Localization.translate("iu.space.expedition.no_expedition"), guiLeft + this.width / 2, guiTop + 25 + 4, 20.0f, 0.5f, ModUtils.convertRGBAcolorToInt(0, 0, 0));
            } else {
                switch (spaceOperation.getOperation()) {
                    case FAIL: {
                        this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other2.png"), (int)((double)(guiLeft + this.width / 2) - 59.625), guiTop + 25, 20.0f, 0.75f, 0.75f, 0, 17, 159, 16);
                        this.getTile().drawCenteredText(poseStack, Localization.translate("iu.space.expedition.failed"), guiLeft + this.width / 2, guiTop + 25 + 4, 20.0f, 0.5f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
                        break;
                    }
                    case SUCCESS: {
                        this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other2.png"), (int)((double)(guiLeft + this.width / 2) - 59.625), guiTop + 25, 20.0f, 0.75f, 0.75f, 0, 0, 159, 16);
                        this.getTile().drawCenteredText(poseStack, Localization.translate("iu.space.expedition.success"), guiLeft + this.width / 2, guiTop + 25 + 4, 20.0f, 0.5f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
                    }
                }
            }
        } else {
            this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other2.png"), (int)((double)(guiLeft + this.width / 2) - 59.625), guiTop + 25, 20.0f, 0.75f, 0.75f, 0, 0, 159, 16);
            this.getTile().drawCenteredText(poseStack, Localization.translate("iu.space.expedition.in_progress"), guiLeft + this.width / 2, guiTop + 25 + 4, 20.0f, 0.5f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
        }
        if (fakeBody == null) {
            if (!this.hoverSend) {
                this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"), guiLeft + 30 + 7, guiTop + 55, 0.0f, 0.75f, 0.75f, 0, 105, 103, 20);
            } else {
                this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"), guiLeft + 30 + 7, guiTop + 55, 0.0f, 0.75f, 0.75f, 0, 125, 103, 20);
            }
            this.getTile().drawCenteredText(poseStack, Localization.translate("iu.space.expedition.send"), (float)(guiLeft + 30 + 7) + 38.25f, guiTop + 55 + 5, 20.0f, 0.5f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
        } else {
            if (!this.hoverBack) {
                this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"), guiLeft + 30 + 7, guiTop + 55, 0.0f, 0.75f, 0.75f, 0, 105, 103, 20);
            } else {
                this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"), guiLeft + 30 + 7, guiTop + 55, 0.0f, 0.75f, 0.75f, 0, 125, 103, 20);
            }
            this.getTile().drawCenteredText(poseStack, Localization.translate("iu.space.expedition.return"), (float)(guiLeft + 30 + 7) + 38.25f, guiTop + 55 + 5, 20.0f, 0.5f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
            if (!this.hoverAuto) {
                this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"), guiLeft + 30 + 7, guiTop + 55 + 35, 0.0f, 0.75f, 0.75f, 0, 105, 103, 20);
            } else {
                this.getTile().drawRect(poseStack, ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/gui_space_other.png"), guiLeft + 30 + 7, guiTop + 55 + 35, 0.0f, 0.75f, 0.75f, 0, 125, 103, 20);
            }
            this.getTile().drawCenteredText(poseStack, Localization.translate("iu.space.auto_" + !fakeBody.getSpaceOperation().getAuto()), (float)(guiLeft + 30 + 7) + 38.25f, guiTop + 55 + 35 + 5, 20.0f, 0.5f, ModUtils.convertRGBAcolorToInt(255, 255, 255));
        }
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, ScrollDirection direction) {
        return super.mouseScrolled(mouseX, mouseY, direction);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY) {
        if (this.hoverDelete) {
            this.getTile().defaultResearchGuis.remove(this);
            ((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).player.playSound(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
            return true;
        }
        if (this.hoverSend) {
            new PacketSendRoversToPlanet((IResearchTable)((Object)((ContainerMenuResearchTableSpace)this.getTile().container).base), ((ContainerMenuResearchTableSpace)this.getTile().container).player, this.getTile().focusedPlanet);
            ((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).player.playSound(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
        }
        if (this.hoverBack) {
            new PacketReturnRoversToPlanet((IResearchTable)((Object)((ContainerMenuResearchTableSpace)this.getTile().container).base), ((ContainerMenuResearchTableSpace)this.getTile().container).player, this.getTile().focusedPlanet);
            ((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).player.playSound(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
        }
        if (this.hoverAuto) {
            new PacketChangeSpaceOperation(((ContainerMenuResearchTableSpace)this.getTile().container).player, this.getTile().focusedPlanet);
            ((ContainerMenuResearchTableSpace)((Object)this.getTile().getContainer())).player.playSound(EnumSound.button.getSoundEvent(), 0.5f, 1.0f);
        }
        return super.mouseClicked(mouseX, mouseY);
    }
}

