/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.widget.AdvancedTooltipWidget;
import com.denfop.blockentity.base.BlockEntityDoubleMolecular;
import com.denfop.containermenu.ContainerMenuBaseDoubleMolecular;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenDoubleMolecularTransformer<T extends ContainerMenuBaseDoubleMolecular>
extends ScreenIndustrialUpgrade<ContainerMenuBaseDoubleMolecular> {
    public final ContainerMenuBaseDoubleMolecular container;

    public ScreenDoubleMolecularTransformer(ContainerMenuBaseDoubleMolecular container1) {
        super(container1, 238, 225);
        this.container = container1;
    }

    public static int floor_double(double p_76128_0_) {
        int i = (int)p_76128_0_;
        return p_76128_0_ < (double)i ? i - 1 : i;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int mouseX, int mouseY) {
        super.drawForegroundLayer(poseStack, mouseX, mouseY);
        new AdvancedTooltipWidget(this, 21, 29, 58, 41).withTooltip(Localization.translate("iu.molecular_info") + "\n" + Localization.translate("iu.molecular_info3") + " " + (((BlockEntityDoubleMolecular)this.container.base).queue ? "x64" : "x1")).drawForeground(poseStack, mouseX, mouseY);
        new AdvancedTooltipWidget(this, 165, 22, 232, 47).withTooltip(Localization.translate("iu.molecular_info1") + "\n" + Localization.translate("iu.molecular_info2")).drawForeground(poseStack, mouseX, mouseY);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
        String name = Localization.translate(((BlockEntityDoubleMolecular)this.container.base).getName());
        this.drawXCenteredString(poseStack, this.imageWidth / 2, 5, Component.nullToEmpty((String)name), ModUtils.convertRGBcolorToInt(255, 255, 255), false);
    }

    @Override
    protected void renderBg(GuiGraphics poseStack, float f, int x, int y) {
        super.renderBg(poseStack, f, x, y);
        this.bindTexture();
        String input = Localization.translate("gui.MolecularTransformer.input") + ": ";
        String output = Localization.translate("gui.MolecularTransformer.output") + ": ";
        String energyPerOperation = Localization.translate("gui.MolecularTransformer.energyPerOperation") + ": ";
        String progress = Localization.translate("gui.MolecularTransformer.progress") + ": ";
        this.bindTexture();
        double chargeLevel = 20.0 * ((BlockEntityDoubleMolecular)this.container.base).getProgress();
        if (!((BlockEntityDoubleMolecular)this.container.base).queue) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 22, this.guiTop + 30, 26, 245, 16, 11);
        } else {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 42, this.guiTop + 30, 26, 245, 16, 11);
        }
        MachineRecipe output3 = ((BlockEntityDoubleMolecular)this.container.base).output;
        if (chargeLevel > 0.0 && !((BlockEntityDoubleMolecular)this.container.base).inputSlot.isEmpty() && output3 != null && ((BlockEntityDoubleMolecular)this.container.base).outputSlot.canAdd(output3.getRecipe().getOutput().items)) {
            if (!((BlockEntityDoubleMolecular)this.container.base).queue) {
                ScreenDoubleMolecularTransformer.bindTexture(this.getTexture());
                this.drawTexturedModalRect(poseStack, this.guiLeft + 30, this.guiTop + 75, 43, 237, 14, (int)chargeLevel);
                ScreenDoubleMolecularTransformer.bindTexture(this.getTexture());
                this.draw(poseStack, input + ((BlockEntityDoubleMolecular)this.container.base).inputSlot.get(0).getDisplayName().getString(), this.guiLeft + 73, this.guiTop + 55, ModUtils.convertRGBcolorToInt(255, 255, 255));
                this.draw(poseStack, input + ((BlockEntityDoubleMolecular)this.container.base).inputSlot.get(1).getDisplayName().getString(), this.guiLeft + 73, this.guiTop + 65, ModUtils.convertRGBcolorToInt(255, 255, 255));
                this.draw(poseStack, output + output3.getRecipe().output.items.get(0).getDisplayName().getString(), this.guiLeft + 73, this.guiTop + 75, ModUtils.convertRGBcolorToInt(255, 255, 255));
                this.draw(poseStack, energyPerOperation + ModUtils.getString(output3.getRecipe().output.metadata.getDouble("energy")) + " EF", this.guiLeft + 73, this.guiTop + 85, ModUtils.convertRGBcolorToInt(255, 255, 255));
                if (((BlockEntityDoubleMolecular)this.container.base).getProgress() * 100.0 <= 100.0) {
                    this.draw(poseStack, progress + ScreenDoubleMolecularTransformer.floor_double(((BlockEntityDoubleMolecular)this.container.base).getProgress() * 100.0) + "%", this.guiLeft + 73, this.guiTop + 95, ModUtils.convertRGBcolorToInt(255, 255, 255));
                }
                this.draw(poseStack, "EF/t: " + ModUtils.getString(((BlockEntityDoubleMolecular)this.container.base).differenceenergy), this.guiLeft + 73, this.guiTop + 105, ModUtils.convertRGBcolorToInt(255, 255, 255));
            } else {
                ItemStack output2 = ((BlockEntityDoubleMolecular)this.container.base).output.getRecipe().output.items.get(0);
                int size = ((BlockEntityDoubleMolecular)this.container.base).output.getRecipe().input.getInputs().get(0).getInputs().get(0).getCount();
                int size2 = ((BlockEntityDoubleMolecular)this.container.base).output.getRecipe().input.getInputs().get(1).getInputs().get(0).getCount();
                int col = size;
                int col1 = size2;
                size = (int)Math.floor((float)((BlockEntityDoubleMolecular)this.container.base).inputSlot.get(0).getCount() / (float)size);
                size2 = (int)Math.floor((float)((BlockEntityDoubleMolecular)this.container.base).inputSlot.get(1).getCount() / (float)size2);
                size = Math.min(size, size2);
                int size1 = !((BlockEntityDoubleMolecular)this.container.base).outputSlot.get(0).isEmpty() ? 64 - ((BlockEntityDoubleMolecular)this.container.base).outputSlot.get(0).getCount() : 64;
                size = Math.min(size1, size);
                size = Math.min(size, output2.getMaxStackSize());
                if (((BlockEntityDoubleMolecular)this.container.base).outputSlot.get(0).isEmpty() || ((BlockEntityDoubleMolecular)this.container.base).outputSlot.get(0).getCount() < 64) {
                    ScreenDoubleMolecularTransformer.bindTexture(this.getTexture());
                    this.drawTexturedModalRect(poseStack, this.guiLeft + 30, this.guiTop + 75, 43, 237, 14, (int)chargeLevel);
                    ScreenDoubleMolecularTransformer.bindTexture(this.getTexture());
                    this.draw(poseStack, input + col * size + "x" + ((BlockEntityDoubleMolecular)this.container.base).inputSlot.get(0).getDisplayName().getString(), this.guiLeft + 73, this.guiTop + 55, ModUtils.convertRGBcolorToInt(255, 255, 255));
                    this.draw(poseStack, input + col1 * size + "x" + ((BlockEntityDoubleMolecular)this.container.base).inputSlot.get(1).getDisplayName().getString(), this.guiLeft + 73, this.guiTop + 65, ModUtils.convertRGBcolorToInt(255, 255, 255));
                    this.draw(poseStack, output + output2.getCount() * size + "x" + output3.getRecipe().output.items.get(0).getDisplayName().getString(), this.guiLeft + 73, this.guiTop + 75, ModUtils.convertRGBcolorToInt(255, 255, 255));
                    this.draw(poseStack, energyPerOperation + ModUtils.getString(output3.getRecipe().output.metadata.getDouble("energy") * (double)size) + " EF", this.guiLeft + 73, this.guiTop + 85, ModUtils.convertRGBcolorToInt(255, 255, 255));
                    if (((BlockEntityDoubleMolecular)this.container.base).getProgress() * 100.0 <= 100.0) {
                        this.draw(poseStack, progress + ScreenDoubleMolecularTransformer.floor_double(((BlockEntityDoubleMolecular)this.container.base).getProgress() * 100.0) + "%", this.guiLeft + 73, this.guiTop + 95, ModUtils.convertRGBcolorToInt(255, 255, 255));
                    }
                    this.draw(poseStack, "EF/t: " + ModUtils.getString(((BlockEntityDoubleMolecular)this.container.base).differenceenergy), this.guiLeft + 73, this.guiTop + 105, ModUtils.convertRGBcolorToInt(255, 255, 255));
                }
            }
        }
    }

    public String getName() {
        return Localization.translate("blockMolecularTransformer.name");
    }

    @Override
    public ResourceLocation getTexture() {
        if (((BlockEntityDoubleMolecular)this.container.base).redstoneMode == 1) {
            return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew_chemical_green.png".toLowerCase());
        }
        if (((BlockEntityDoubleMolecular)this.container.base).redstoneMode == 2) {
            return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew_gold.png".toLowerCase());
        }
        if (((BlockEntityDoubleMolecular)this.container.base).redstoneMode == 3) {
            return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew_red.png".toLowerCase());
        }
        if (((BlockEntityDoubleMolecular)this.container.base).redstoneMode == 4) {
            return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew_silver.png".toLowerCase());
        }
        if (((BlockEntityDoubleMolecular)this.container.base).redstoneMode == 5) {
            return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew_violet.png".toLowerCase());
        }
        if (((BlockEntityDoubleMolecular)this.container.base).redstoneMode == 6) {
            return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew_blue.png".toLowerCase());
        }
        if (((BlockEntityDoubleMolecular)this.container.base).redstoneMode == 7) {
            return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew_green.png".toLowerCase());
        }
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiDoubleMolecularTransformerNew.png".toLowerCase());
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = this.guiLeft;
        int yMin = this.guiTop;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 219 && x <= 232 && y >= 25 && y <= 45) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 0.0);
        }
        if (x >= 165 && x <= 178 && y >= 25 && y <= 45) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, -1.0);
        }
        if (x >= 22 && x <= 57 && y >= 30 && y <= 40) {
            new PacketUpdateServerTile((BlockEntity)this.container.base, 1.0);
        }
    }
}

