/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.screen;

import com.denfop.api.sound.AudioFixer;
import com.denfop.api.widget.EnumTypeComponent;
import com.denfop.api.widget.ScreenWidget;
import com.denfop.api.widget.WidgetDefault;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.mechanism.cooling.BlockEntityCooling;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuCoolMachine;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class ScreenCoolMachine<T extends ContainerMenuCoolMachine>
extends ScreenMain<ContainerMenuCoolMachine> {
    public ContainerMenuCoolMachine container;
    public String name;

    public ScreenCoolMachine(ContainerMenuCoolMachine guiContainer) {
        super(guiContainer);
        this.container = guiContainer;
        this.name = Localization.translate(((BlockEntityCooling)guiContainer.base).getName());
        this.addComponent(new ScreenWidget(this, 3, 14, EnumTypeComponent.SOUND_BUTTON, new WidgetDefault<ComponentSoundButton>(new ComponentSoundButton((BlockEntityBase)((Object)this.container.base), 10, (AudioFixer)((Object)this.container.base)))));
        this.componentList.add(new ScreenWidget(this, 113, 21, EnumTypeComponent.ENERGY_HEIGHT, new WidgetDefault<Energy>(((BlockEntityCooling)this.container.base).energy)));
        this.componentList.add(new ScreenWidget(this, 51, 41, EnumTypeComponent.COOL_ENERGY_WEIGHT, new WidgetDefault<CoolComponent>(((BlockEntityCooling)this.container.base).cold)));
        this.componentList.add(new ScreenWidget(this, 20, 37, EnumTypeComponent.WORK_BUTTON, new WidgetDefault<1>(new ComponentButton(this, (BlockEntityBase)((Object)this.container.base), 2, ""){

            @Override
            public String getText() {
                return ((BlockEntityCooling)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((BlockEntityCooling)this.getEntityBlock()).work;
            }
        })));
        this.componentList.add(new ScreenWidget(this, 53, 60, EnumTypeComponent.PLUS_BUTTON, new WidgetDefault<2>(new ComponentButton(this, (BlockEntityBase)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return "+4";
            }
        })));
        this.componentList.add(new ScreenWidget(this, 78, 60, EnumTypeComponent.MINUS_BUTTON, new WidgetDefault<3>(new ComponentButton(this, (BlockEntityBase)((Object)this.container.base), 1, ""){

            @Override
            public String getText() {
                return "-4";
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.cool_storage.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.cooling;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.draw(poseStack, this.name, (this.imageWidth - this.getStringWidth(this.name)) / 2, 6, 0x404040);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ScreenCoolMachine.bindTexture(this.getTexture());
        int xOffset = (this.width - this.imageWidth) / 2;
        int yOffset = (this.height - this.imageHeight) / 2;
        ScreenCoolMachine.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, xOffset + 3, yOffset + 3, 0, 0, 10, 10);
        ScreenCoolMachine.bindTexture(this.getTexture());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }
}

