/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.water;

import com.denfop.api.windsystem.WindRotor;
import com.denfop.blockentity.mechanism.water.BlockEntityBaseWaterGenerator;
import com.denfop.render.windgenerator.RotorModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

public class WaterGeneratorRenderer
implements BlockEntityRenderer<BlockEntityBaseWaterGenerator> {
    private static final Map<Integer, RotorModel> rotorModels = new HashMap<Integer, RotorModel>();

    public WaterGeneratorRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityBaseWaterGenerator tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockEntityBaseWaterGenerator windGen = tile;
        Level world = tile.getLevel();
        BlockPos pos = tile.getBlockPos();
        if (tile.getRotor() == null) {
            return;
        }
        int diameter = 3;
        if (diameter == 0) {
            return;
        }
        float angle = windGen.getAngle();
        ResourceLocation rotorTexture = windGen.getRotorRenderTexture();
        RotorModel model = rotorModels.computeIfAbsent(diameter, RotorModel::new);
        Direction facing = windGen.getFacing();
        poseStack.pushPose();
        poseStack.translate(0.0, 0.5, 0.0);
        switch (facing) {
            case NORTH: {
                poseStack.translate(0.5, 0.0, 0.0);
                break;
            }
            case EAST: {
                poseStack.translate(1.0, 0.0, 0.5);
                break;
            }
            case SOUTH: {
                poseStack.translate(0.5, 0.0, 1.0);
                break;
            }
            case WEST: {
                poseStack.translate(0.0, 0.0, 0.5);
            }
        }
        switch (facing) {
            case NORTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-180.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-270.0f));
                break;
            }
            case UP: {
                poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            }
        }
        if (windGen.getSpace()) {
            angle = windGen.getAngle();
            WindRotor rotor = tile.getRotor();
            if (rotor.getMaxCustomDamage(tile.slot.get(0)) - rotor.getCustomDamage(tile.slot.get(0)) == 0) {
                angle = 0.0f;
            }
            if (!Minecraft.getInstance().isPaused()) {
                poseStack.mulPose(Axis.XP.rotationDegrees(angle));
            }
        }
        poseStack.translate(-0.2f, 0.0f, 0.0f);
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)rotorTexture));
        model.renderToBuffer(poseStack, buffer, packedLight, OverlayTexture.NO_OVERLAY, -1);
        poseStack.popPose();
    }

    public boolean shouldRenderOffScreen(BlockEntityBaseWaterGenerator tile) {
        return true;
    }
}

