/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.transport;

import com.denfop.blockentity.transport.tiles.BlockEntityMultiCable;
import com.denfop.render.transport.DataCable;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class TileEntityCableRenderer
implements BlockEntityRenderer<BlockEntityMultiCable> {
    private final BlockEntityRendererProvider.Context context;

    public TileEntityCableRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(BlockEntityMultiCable te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        DataCable data = te.dataCable;
        if (data == null) {
            te.dataCable = data = new DataCable(te.connectivity, ItemStack.EMPTY, null);
        }
        poseStack.pushPose();
        poseStack.translate(0.0, 0.0, 0.0);
        if (te.stackFacade != null && !te.stackFacade.isEmpty()) {
            if (data.getItemStack().isEmpty() || !ItemStack.isSameItem((ItemStack)data.getItemStack(), (ItemStack)te.stackFacade)) {
                data.setItemStack(te.stackFacade);
                data.setBakedModel(Minecraft.getInstance().getItemRenderer().getModel(te.stackFacade, te.getLevel(), null, 0));
            }
            this.renderBlock(data, poseStack, bufferSource, packedLight);
        }
        poseStack.popPose();
    }

    private void renderBlock(DataCable item, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.scale(2.0f, 2.0f, 2.0f);
        Minecraft.getInstance().getItemRenderer().render(item.getItemStack(), ItemDisplayContext.FIXED, false, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY, item.getBakedModel());
        poseStack.popPose();
    }
}

