/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.streak;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.render.streak.RGB;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderPlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.joml.Matrix4f;

public class EventSpectralSuitEffect {
    public static final ResourceLocation texture = ResourceLocation.parse((String)"industrialupgrade:textures/item/effect.png");
    private static final Map<String, ArrayList<StreakLocation>> playerLoc = new HashMap<String, ArrayList<StreakLocation>>();
    public final int[] red = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 222, 186, 150, 124, 96, 67, 40, 27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 34, 56, 78, 102, 121, 145, 176, 201, 218, 230, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
    public final int[] green = new int[]{0, 24, 36, 54, 72, 96, 120, 145, 172, 192, 216, 234, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 234, 214, 195, 176, 153, 137, 112, 94, 86, 55, 31, 15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public final int[] blue = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 32, 45, 68, 78, 103, 118, 138, 151, 178, 205, 221, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 240, 228, 208, 186, 165, 149, 132, 115, 102, 97, 76, 53, 32, 15, 0};

    public static ArrayList<StreakLocation> getPlayerStreakLocationInfo(Player player) {
        ArrayList loc = playerLoc.computeIfAbsent(player.getName().getString(), k -> new ArrayList());
        if (loc.size() < 20) {
            for (int i = 0; i < 20 - loc.size(); ++i) {
                loc.add(0, new StreakLocation(player));
            }
        } else if (loc.size() > 20) {
            loc.remove(0);
        }
        return loc;
    }

    public static float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        this.render(event.getEntity(), event.getPartialTick(), event.getPoseStack());
    }

    public void render(Player player, float partialTicks, PoseStack poseStack) {
        Minecraft mc = Minecraft.getInstance();
        if (player == null) {
            return;
        }
        PlayerStreakInfo playerStreak1 = IUCore.mapStreakInfo.get(player.getName().getString());
        boolean needRender = true;
        if (playerStreak1 != null) {
            needRender = this.isRenderStreak(player);
        }
        if (needRender && this.isRenderStreak(player)) {
            ArrayList<StreakLocation> loc = EventSpectralSuitEffect.getPlayerStreakLocationInfo(player);
            poseStack.pushPose();
            float startGrad = 5.0f - partialTicks;
            float endGrad = 20.0f - partialTicks;
            for (int i = loc.size() - 2; i >= 0; --i) {
                double grad1;
                float startAlpha;
                int start = i;
                StreakLocation infoStart = loc.get(i);
                float f = (float)i < endGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)i / endGrad, 0.0f, 0.8f) : (startAlpha = (float)i > (float)(loc.size() - 2) - startGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)(loc.size() - 2 - i) / startGrad, 0.0f, 0.8f) : 0.8f);
                if (mc.level.getGameTime() - infoStart.lastTick > 40L) break;
                StreakLocation infoEnd = null;
                double grad = 500.0;
                --i;
                while (i >= 0) {
                    StreakLocation infoPoint = loc.get(i);
                    if (infoStart.isSprinting && loc.size() - 2 - i < 6) {
                        infoEnd = infoPoint;
                        --start;
                        --i;
                        break;
                    }
                    if (infoPoint.hasSameCoords(infoStart)) {
                        --start;
                        --i;
                        continue;
                    }
                    grad1 = infoPoint.posZ - infoStart.posZ / (infoPoint.posX - infoStart.posX);
                    if (grad == grad1 && infoPoint.posY == infoStart.posY) {
                        infoEnd = infoPoint;
                        --start;
                        --i;
                        continue;
                    }
                    if (grad != 500.0) break;
                    grad = grad1;
                    infoEnd = infoPoint;
                    --i;
                }
                if (infoEnd == null) continue;
                float endAlpha = (float)(i += 2) < endGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)(i - 1) / endGrad, 0.0f, 0.8f) : ((float)i > (float)(loc.size() - 1) - startGrad ? EventSpectralSuitEffect.clamp(0.8f * (float)(loc.size() - 1 - i) / startGrad, 0.0f, 0.8f) : 0.8f);
                grad1 = infoStart.posX - mc.gameRenderer.getMainCamera().getPosition().x;
                double posY = infoStart.posY - mc.gameRenderer.getMainCamera().getPosition().y;
                double posZ = infoStart.posZ - mc.gameRenderer.getMainCamera().getPosition().z;
                double nextPosX = infoEnd.posX - mc.gameRenderer.getMainCamera().getPosition().x;
                double nextPosY = infoEnd.posY - mc.gameRenderer.getMainCamera().getPosition().y;
                double nextPosZ = infoEnd.posZ - mc.gameRenderer.getMainCamera().getPosition().z;
                float deltaX = (float)(nextPosX - grad1);
                float deltaZ = (float)(nextPosZ - posZ);
                poseStack.pushPose();
                poseStack.translate(grad1, posY, posZ);
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.disableCull();
                RenderSystem.enableDepthTest();
                RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
                PlayerStreakInfo playerStreak = IUCore.mapStreakInfo.get(player.getName().getString());
                if (playerStreak == null) {
                    playerStreak = new PlayerStreakInfo(new RGB(0, 0, 0), false);
                    IUCore.mapStreakInfo.put(player.getName().getString(), playerStreak);
                }
                double red = (double)playerStreak.getRgb().getRed() / 255.0;
                double green = (double)playerStreak.getRgb().getGreen() / 255.0;
                double blue = (double)playerStreak.getRgb().getBlue() / 255.0;
                boolean rgb = playerStreak.isRainbow();
                if (rgb) {
                    long worldTime = mc.level.getGameTime();
                    red = (float)this.red[(int)(worldTime % (long)this.red.length)] / 255.0f;
                    green = (float)this.green[(int)(worldTime % (long)this.green.length)] / 255.0f;
                    blue = (float)this.blue[(int)(worldTime % (long)this.red.length)] / 255.0f;
                }
                Color color = new Color((float)red, (float)green, (float)blue, startAlpha);
                ScreenIndustrialUpgrade.bindTexture(texture);
                BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
                Matrix4f matrix4f = poseStack.last().pose();
                RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
                buffer.addVertex(matrix4f, 0.0f, 0.0f, 0.0f).setUv((float)infoStart.startU, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), 255);
                buffer.addVertex(matrix4f, 0.0f, 0.0f + infoStart.height, 0.0f).setUv((float)infoStart.startU, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), 255);
                double endTex = infoEnd.startU - (double)start + (double)i;
                if (endTex > infoStart.startU) {
                    endTex -= 1.0;
                }
                double distX = infoStart.posX - infoEnd.posX;
                double distZ = infoStart.posZ - infoEnd.posZ;
                float correctedDeltaX = deltaX > 0.0f ? deltaX : 0.0f;
                float correctedDeltaZ = deltaZ > 0.0f ? deltaZ : 0.0f;
                for (double scales = Math.sqrt(distX * distX + distZ * distZ) / (double)infoStart.height; scales > 1.0; scales -= 1.0) {
                    endTex += 1.0;
                }
                buffer.addVertex(matrix4f, (float)Math.abs(nextPosX - grad1), (float)(nextPosY - posY + (double)infoEnd.height), (float)Math.abs(nextPosZ - posZ)).setUv((float)endTex, 0.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), 255);
                buffer.addVertex(matrix4f, (float)Math.abs(nextPosX - grad1), (float)(nextPosY - posY), (float)Math.abs(nextPosZ - posZ)).setUv((float)endTex, 1.0f).setColor(color.getRed(), color.getGreen(), color.getBlue(), 255);
                BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
                RenderSystem.enableBlend();
                RenderSystem.enableCull();
                RenderSystem.disableDepthTest();
                poseStack.popPose();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            poseStack.popPose();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(PlayerTickEvent.Post event) {
        Player player;
        if (event.getEntity().level().isClientSide && this.isRenderStreak(player = event.getEntity())) {
            ArrayList<StreakLocation> loc = EventSpectralSuitEffect.getPlayerStreakLocationInfo(player);
            StreakLocation oldest = loc.get(0);
            loc.remove(0);
            loc.add(oldest);
            oldest.update(player);
            StreakLocation newest = loc.get(loc.size() - 2);
            double distX = newest.posX - oldest.posX;
            double distZ = newest.posZ - oldest.posZ;
            newest.startU += Math.sqrt(distX * distX + distZ * distZ) / (double)newest.height;
            while (oldest.startU > 1.0) {
                oldest.startU -= 1.0;
            }
        }
    }

    private boolean isRenderStreak(Player player) {
        NonNullList armors = player.getInventory().armor;
        return Minecraft.getInstance().screen == null && ((ItemStack)armors.get(2)).getItem() == IUItem.spectral_chestplate.getItem();
    }

    public static class StreakLocation {
        public double posX;
        public double posY;
        public double posZ;
        public float renderYawOffset;
        public float rotationYawHead;
        public float rotationPitch;
        public boolean isSprinting;
        public long lastTick;
        public float height;
        public double startU;

        public StreakLocation(Player player) {
            this.update(player);
        }

        public void update(Player player) {
            this.posX = player.getX();
            this.posY = player.getBoundingBox().minY;
            this.posZ = player.getZ();
            this.renderYawOffset = player.yBodyRot;
            this.rotationYawHead = player.getViewYRot(1.0f);
            this.rotationPitch = player.getViewXRot(1.0f);
            this.isSprinting = player.isSprinting();
            this.lastTick = player.level().getGameTime();
            this.height = player.getBbHeight() * 2.0f;
        }

        public boolean hasSameCoords(StreakLocation loc) {
            return loc.posX == this.posX && loc.posY == this.posY && loc.posZ == this.posZ && loc.height == this.height;
        }
    }
}

