/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.pump;

import com.denfop.blockentity.mechanism.BlockEntityPrimalPump;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public class TileEntityRenderPump
implements BlockEntityRenderer<BlockEntityPrimalPump> {
    private final BlockEntityRendererProvider.Context contex;

    public TileEntityRenderPump(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public void render(BlockEntityPrimalPump tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            if (tile.getBlockPos().equals((Object)hitResult2.getBlockPos())) {
                poseStack.pushPose();
                poseStack.translate(0.5, 1.75, 0.5);
                MutableComponent text = tile.fluidTank.getFluid().isEmpty() ? Component.literal((String)("FluidTank: 0/" + tile.fluidTank.getCapacity())) : Component.literal((String)(tile.fluidTank.getFluid().getHoverName().getString() + ": " + tile.fluidTank.getFluidAmount() + "/" + tile.fluidTank.getCapacity()));
                this.renderFloatingText((Component)text, poseStack, bufferSource, packedLight);
                poseStack.popPose();
            }
        }
    }

    private void renderFloatingText(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean flag = true;
        boolean i = false;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.0f);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float f1 = -font.width((FormattedText)text) / 2;
        font.drawInBatch(text, f1, (float)i, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        if (flag) {
            font.drawInBatch(text, f1, (float)i, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        poseStack.popPose();
    }
}

