/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.oilquarry;

import com.denfop.IUItem;
import com.denfop.api.vein.common.Type;
import com.denfop.blockentity.base.BlockEntityQuarryVein;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Matrix4f;

public class QuarryOilRenderer
implements BlockEntityRenderer<BlockEntityQuarryVein> {
    private final BlockEntityRendererProvider.Context contex;
    private float rotation = 0.0f;
    private float prevRotation = 0.0f;

    public QuarryOilRenderer(BlockEntityRendererProvider.Context context) {
        this.contex = context;
    }

    public void render(BlockEntityQuarryVein tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (tile.vein == null || !tile.vein.get()) {
            return;
        }
        if (tile.vein.getType() != Type.EMPTY) {
            String typeString;
            String varietyString;
            poseStack.pushPose();
            poseStack.translate(0.5, 1.35, 0.5);
            poseStack.scale(0.25f, 0.25f, 0.25f);
            poseStack.mulPose(Axis.XP.rotationDegrees(this.rotation));
            poseStack.mulPose(Axis.YP.rotationDegrees(this.rotation));
            poseStack.mulPose(Axis.ZP.rotationDegrees(this.rotation));
            BlockState state = null;
            if (state == null) {
                state = tile.vein.getType() == Type.VEIN ? (tile.vein.isOldMineral() ? IUItem.heavyore.getStateFromMeta(tile.vein.getMeta()) : IUItem.mineral.getStateFromMeta(tile.vein.getMeta())) : (tile.vein.getType() == Type.OIL ? IUItem.oilblock.getBlock(0).defaultBlockState() : IUItem.gasBlock.getBlock(0).defaultBlockState());
            }
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            BakedModel model = dispatcher.getBlockModel(state);
            dispatcher.getModelRenderer().renderModel(poseStack.last(), bufferSource.getBuffer(RenderType.cutout()), state, model, 1.0f, 1.0f, 1.0f, packedLight, OverlayTexture.NO_OVERLAY);
            poseStack.popPose();
            this.rotation += 0.25f;
            String stack = null;
            if (tile.vein.getType() == Type.VEIN) {
                stack = tile.vein.isOldMineral() ? Localization.translate(new ItemStack((ItemLike)IUItem.heavyore.getItem(tile.vein.getMeta()), 1).getDescriptionId()) : Localization.translate(new ItemStack((ItemLike)IUItem.mineral.getItem(tile.vein.getMeta()), 1).getDescriptionId());
            } else if (tile.vein.getType() == Type.OIL) {
                stack = Localization.translate(new ItemStack((ItemLike)IUItem.oilblock.getItem()).getDescriptionId());
            } else if (tile.vein.getType() == Type.GAS) {
                stack = Localization.translate(((IUFluid)((Object)FluidName.fluidgas.getInstance().get())).getFluidType().getDescriptionId());
            }
            int col = tile.vein.getCol();
            boolean isOil = tile.vein.getType() == Type.OIL || tile.vein.getType() == Type.GAS;
            int colmax = tile.vein.getMaxCol();
            int variety = tile.vein.getMeta() / 3;
            int type = tile.vein.getMeta() % 3;
            String string = varietyString = variety == 0 ? "iu.sweet_oil" : "iu.sour_oil";
            String string2 = type == 0 ? "iu.light_oil" : (typeString = type == 1 ? "iu.medium_oil" : "iu.heavy_oil");
            MutableComponent itextcomponent = isOil ? (tile.vein.getType() != Type.GAS ? Component.literal((String)(Localization.translate(varietyString) + " " + Localization.translate(typeString))).append((Component)Component.literal((String)(" " + stack))) : Component.literal((String)stack)) : Component.literal((String)stack);
            MutableComponent itextcomponent1 = Component.literal((String)(col + (isOil ? "mb" : "") + "/" + colmax + (isOil ? "mb" : "")));
            poseStack.translate(0.5, (double)2.15f, 0.5);
            this.drawNameplate((Component)itextcomponent, poseStack, bufferSource, packedLight);
            poseStack.translate(0.0f, -0.25f, 0.0f);
            this.drawNameplate((Component)itextcomponent1, poseStack, bufferSource, packedLight);
        }
    }

    private void drawNameplate(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean flag = true;
        boolean i = false;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.0f);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float f1 = -font.width((FormattedText)text) / 2;
        font.drawInBatch(text, f1, (float)i, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        if (flag) {
            font.drawInBatch(text, f1, (float)i, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        poseStack.popPose();
    }
}

