/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.fluidheater;

import com.denfop.blockentity.mechanism.BlockEntityPrimalFluidHeater;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public class TileEntityRenderFluidHeater
implements BlockEntityRenderer<BlockEntityPrimalFluidHeater> {
    private final BlockEntityRendererProvider.Context contex;

    public TileEntityRenderFluidHeater(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public void render(BlockEntityPrimalFluidHeater tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            if (tile.getBlockPos().equals((Object)hitResult2.getBlockPos())) {
                poseStack.pushPose();
                poseStack.translate(0.5, 1.75, 0.5);
                MutableComponent text = tile.fluidTank1.isEmpty() ? Component.literal((String)("FluidTank: 0/" + tile.fluidTank1.getCapacity())) : Component.literal((String)(tile.fluidTank1.getFluid().getHoverName().getString() + ": " + tile.fluidTank1.getFluidAmount() + "/" + tile.fluidTank1.getCapacity()));
                MutableComponent text1 = tile.fluidTank2.isEmpty() ? Component.literal((String)("FluidTank: 0/" + tile.fluidTank2.getCapacity())) : Component.literal((String)(tile.fluidTank2.getFluid().getHoverName().getString() + ": " + tile.fluidTank2.getFluidAmount() + "/" + tile.fluidTank2.getCapacity()));
                MutableComponent text2 = Component.literal((String)(String.format("%d", (int)(tile.getProgress() * 100.0)) + "%"));
                this.renderFloatingText((Component)text, poseStack, bufferSource, packedLight);
                poseStack.translate(0.0, -0.25, 0.0);
                this.renderFloatingText((Component)text1, poseStack, bufferSource, packedLight);
                poseStack.translate(0.0, -0.25, 0.0);
                this.renderFloatingText((Component)text2, poseStack, bufferSource, packedLight);
                poseStack.popPose();
            }
        }
    }

    private void renderFloatingText(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean flag = true;
        boolean i = false;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.0f);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float f1 = -font.width((FormattedText)text) / 2;
        font.drawInBatch(text, f1, (float)i, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        if (flag) {
            font.drawInBatch(text, f1, (float)i, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        poseStack.popPose();
    }
}

