/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.apiary;

import com.denfop.blockentity.bee.BlockEntityApiary;
import com.denfop.blockentity.bee.EnumProblem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.ClientHooks;

public class TileEntityRenderApiary
implements BlockEntityRenderer<BlockEntityApiary> {
    private final BlockEntityRendererProvider.Context contex;
    private ItemStack flower;
    public static boolean register = false;
    private float rotation;
    private float prevRotation;

    public TileEntityRenderApiary(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public void render(BlockEntityApiary te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        if (te.problemList != null && !te.problemList.isEmpty()) {
            if (!register) {
                register = true;
                this.flower = new ItemStack((ItemLike)Items.POPPY);
            }
            if (te.problemList.contains((Object)EnumProblem.FOOD) || te.problemList.contains((Object)EnumProblem.JELLY)) {
                this.renderItem(this.flower, te.getLevel(), poseStack, bufferSource, packedLight, combinedOverlay, partialTicks);
            }
        }
    }

    private int transformModelCount(PoseStack poseStack, float partialTicks) {
        int modelCount = 1;
        float offsetY = 1.0f;
        poseStack.translate(0.5, (double)(0.25f * offsetY) + 0.25, 0.5);
        poseStack.scale(0.75f, 0.75f, 0.75f);
        this.prevRotation = this.rotation = (this.prevRotation + (this.rotation - this.prevRotation) * partialTicks) % 360.0f;
        this.rotation += 2.0f;
        poseStack.mulPose(Axis.YP.rotationDegrees(this.rotation));
        return modelCount;
    }

    public void renderItem(ItemStack itemStack, Level level, PoseStack poseStack, MultiBufferSource buffer, int light, int overlay, float partialTicks) {
        if (itemStack.isEmpty()) {
            return;
        }
        BakedModel bakedModel = this.contex.getItemRenderer().getModel(itemStack, level, null, 0);
        RandomSource random = level.random;
        if (bakedModel != null) {
            boolean isGui3d = bakedModel.isGui3d();
            poseStack.pushPose();
            poseStack.translate(0.0f, 1.0f, 0.0f);
            int count = this.transformModelCount(poseStack, partialTicks);
            for (int i = 0; i < 1; ++i) {
                poseStack.pushPose();
                if (isGui3d) {
                    if (i > 0) {
                        float xOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        yOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        float zOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.15f;
                        poseStack.translate(xOffset, yOffset, zOffset);
                    }
                } else if (i > 0) {
                    float xOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    yOffset = (random.nextFloat() * 2.0f - 1.0f) * 0.075f;
                    poseStack.translate(xOffset, yOffset, 0.0f);
                }
                BakedModel transformedModel = ClientHooks.handleCameraTransforms((PoseStack)new PoseStack(), (BakedModel)bakedModel, (ItemDisplayContext)ItemDisplayContext.GROUND, (boolean)false);
                this.contex.getItemRenderer().render(itemStack, ItemDisplayContext.FIXED, false, poseStack, buffer, light, overlay, transformedModel);
                poseStack.popPose();
            }
            poseStack.popPose();
        }
    }
}

