/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render;

import com.denfop.blockentity.mechanism.BlockEntityPrimalGasChamber;
import com.denfop.render.RenderFluidBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.joml.Matrix4f;

public class TileEntityRenderGasChamber
implements BlockEntityRenderer<BlockEntityPrimalGasChamber> {
    private final BlockEntityRendererProvider.Context contex;

    public TileEntityRenderGasChamber(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
    }

    public void render(BlockEntityPrimalGasChamber tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        this.renderTanks(tile, poseStack, bufferSource, packedLight, combinedOverlay);
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult hitResult2 = (BlockHitResult)hitResult;
            if (tile.getBlockPos().equals((Object)hitResult2.getBlockPos())) {
                poseStack.pushPose();
                poseStack.translate(0.5, 3.25, 0.5);
                MutableComponent text = tile.fluidTank1.isEmpty() ? Component.literal((String)("FluidTank: 0/" + tile.fluidTank1.getCapacity())) : Component.literal((String)(tile.fluidTank1.getFluid().getHoverName().getString() + ": " + tile.fluidTank1.getFluidAmount() + "/" + tile.fluidTank1.getCapacity()));
                MutableComponent text1 = tile.fluidTank2.isEmpty() ? Component.literal((String)("FluidTank: 0/" + tile.fluidTank2.getCapacity())) : Component.literal((String)(tile.fluidTank2.getFluid().getHoverName().getString() + ": " + tile.fluidTank2.getFluidAmount() + "/" + tile.fluidTank2.getCapacity()));
                MutableComponent text2 = tile.fluidTank3.isEmpty() ? Component.literal((String)("FluidTank: 0/" + tile.fluidTank3.getCapacity())) : Component.literal((String)(tile.fluidTank3.getFluid().getHoverName().getString() + ": " + tile.fluidTank3.getFluidAmount() + "/" + tile.fluidTank3.getCapacity()));
                MutableComponent text3 = Component.literal((String)(String.format("%d", (int)(tile.getProgress() * 100.0)) + "%"));
                this.renderFloatingText((Component)text, poseStack, bufferSource, packedLight);
                poseStack.translate(0.0, -0.25, 0.0);
                this.renderFloatingText((Component)text1, poseStack, bufferSource, packedLight);
                poseStack.translate(0.0, -0.25, 0.0);
                this.renderFloatingText((Component)text2, poseStack, bufferSource, packedLight);
                poseStack.translate(0.0, -0.25, 0.0);
                this.renderFloatingText((Component)text3, poseStack, bufferSource, packedLight);
                poseStack.popPose();
            }
        }
    }

    private void renderTanks(BlockEntityPrimalGasChamber tile, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        float scale;
        if (!tile.fluidTank1.getFluid().isEmpty() && tile.fluidTank1.getFluid().getFluid() != null & tile.fluidTank1.getFluid().getFluid() != Fluids.EMPTY) {
            poseStack.pushPose();
            poseStack.translate(0.175, 0.0, 0.175);
            if (tile.facing == 2 || tile.facing == 3) {
                poseStack.translate(0.795, 1.0, -0.10300000000000001);
            } else {
                poseStack.translate(-0.10300000000000001, 1.0, 0.795);
            }
            scale = (float)tile.fluidTank1.getFluidAmount() * 1.0f / (float)tile.fluidTank1.getCapacity();
            scale *= 0.94f;
            if (tile.facing == 2 || tile.facing == 3) {
                RenderFluidBlock.renderFluid(tile.fluidTank1.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.38f, 0.95f);
            } else {
                RenderFluidBlock.renderFluid(tile.fluidTank1.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.95f, 0.38f);
            }
            poseStack.popPose();
        }
        if (!tile.fluidTank2.getFluid().isEmpty() && tile.fluidTank2.getFluid().getFluid() != null & tile.fluidTank2.getFluid().getFluid() != Fluids.EMPTY) {
            poseStack.pushPose();
            poseStack.translate(0.175, 0.0, 0.175);
            if (tile.facing == 2 || tile.facing == 3) {
                poseStack.translate(0.125, 1.0, -0.10300000000000001);
            } else {
                poseStack.translate(-0.10300000000000001, 1.0, 0.125);
            }
            scale = (float)tile.fluidTank2.getFluidAmount() * 1.0f / (float)tile.fluidTank2.getCapacity();
            scale *= 0.94f;
            if (tile.facing == 2 || tile.facing == 3) {
                RenderFluidBlock.renderFluid(tile.fluidTank2.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.38f, 0.95f);
            } else {
                RenderFluidBlock.renderFluid(tile.fluidTank2.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.95f, 0.38f);
            }
            poseStack.popPose();
        }
        if (!tile.fluidTank3.getFluid().isEmpty() && tile.fluidTank3.getFluid().getFluid() != null & tile.fluidTank3.getFluid().getFluid() != Fluids.EMPTY) {
            poseStack.pushPose();
            poseStack.translate(0.0251, 0.0, 0.0251);
            scale = (float)tile.fluidTank3.getFluidAmount() * 1.0f / (float)tile.fluidTank3.getCapacity();
            scale *= 0.94f;
            if (tile.facing == 2 || tile.facing == 3) {
                RenderFluidBlock.renderFluid(tile.fluidTank3.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.95f, 0.95f);
            } else {
                RenderFluidBlock.renderFluid(tile.fluidTank3.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.95f, 0.95f);
            }
            poseStack.popPose();
        }
    }

    private void renderFloatingText(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean flag = true;
        boolean i = false;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.0f);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float f1 = -font.width((FormattedText)text) / 2;
        font.drawInBatch(text, f1, (float)i, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        if (flag) {
            font.drawInBatch(text, f1, (float)i, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        poseStack.popPose();
    }
}

