/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.register;

import com.denfop.blocks.BlockFluidIU;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.blocks.fluid.IUFluidType;
import com.denfop.dataregistry.DataItem;
import com.denfop.items.ItemBucket;
import com.denfop.register.Register;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredHolder;

public class FluidHandler {
    public final IUFluidType fluidType;
    public final DeferredHolder<Block, BlockFluidIU> liquedBlock;
    public final DeferredHolder<Fluid, IUFluid> source;
    public final DeferredHolder<Fluid, IUFluid> flowing;
    private BaseFlowingFluid.Properties properties;

    public FluidHandler(IUFluidType fluidType, FluidName fluidName) {
        DeferredHolder blockRegistryObject;
        this.fluidType = fluidType;
        this.source = Register.FLUIDS.register(fluidName.getName().toLowerCase(), () -> new IUFluid(this.properties, true));
        this.flowing = Register.FLUIDS.register(fluidName.getName().toLowerCase() + "_flowing", () -> new IUFluid(this.properties, false));
        MapColor steam = MapColor.COLOR_GRAY;
        DeferredHolder bucket = Register.ITEMS.register("bucket/" + fluidName.name().toLowerCase().replace("fluid", ""), () -> new ItemBucket((Fluid)this.source.get(), fluidName));
        DataItem.objects.add((DeferredHolder<Item, Item>)bucket);
        this.liquedBlock = blockRegistryObject = Register.BLOCKS.register("fluid/" + fluidName.name().toLowerCase(), () -> new BlockFluidIU((Supplier<? extends FlowingFluid>)this.source, BlockBehaviour.Properties.of().mapColor(steam).liquid().lightLevel(state -> ((IUFluid)((Object)((Object)((Object)this.source.get())))).getFluidType().getLightLevel()).replaceable()));
        this.properties = new BaseFlowingFluid.Properties(() -> this.fluidType, this.source, this.flowing).slopeFindDistance(2).levelDecreasePerBlock(2).bucket((Supplier)bucket).block((Supplier)blockRegistryObject);
    }

    public DeferredHolder<Block, BlockFluidIU> getLiquedBlock() {
        return this.liquedBlock;
    }

    public IUFluidType getFluidType() {
        return this.fluidType;
    }

    public BaseFlowingFluid.Properties getProperties() {
        return this.properties;
    }

    public void setProperties(BaseFlowingFluid.Properties properties) {
        this.properties = properties;
    }
}

