/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.System;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.denfop.recipe.universalrecipe.SystemRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SystemSerializer
implements RecipeSerializer<SystemRecipe> {
    public static final MapCodec<SystemRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(SystemRecipe::getName), (App)Codec.INT.fieldOf("distance").forGetter(SystemRecipe::getDistanceFromStar)).apply((Applicative)instance, (name, distanceFromStar) -> {
        if (!PlanetSerializer.stringList.contains("system_" + name)) {
            SpaceInit.regSystem.add(() -> new System((String)name, (int)distanceFromStar));
            PlanetSerializer.stringList.add("system_" + name);
        }
        return new SystemRecipe((String)name, (Integer)distanceFromStar);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, SystemRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, SystemRecipe::getName, (StreamCodec)ByteBufCodecs.VAR_INT, SystemRecipe::getDistanceFromStar, (name, distanceFromStar) -> {
        if (!PlanetSerializer.stringList.contains("system_" + name)) {
            SpaceInit.regSystem.add(() -> new System((String)name, (int)distanceFromStar));
            PlanetSerializer.stringList.add("system_" + name);
        }
        return new SystemRecipe((String)name, (Integer)distanceFromStar);
    });

    public MapCodec<SystemRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SystemRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

