/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.ISystem;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.Star;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.denfop.recipe.universalrecipe.StarRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class StarSerializer
implements RecipeSerializer<StarRecipe> {
    public static final MapCodec<StarRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(recipe -> recipe.name), (App)Codec.STRING.fieldOf("system").forGetter(recipe -> recipe.systemName), (App)Codec.STRING.fieldOf("texture").forGetter(recipe -> recipe.texturePath), (App)Codec.INT.fieldOf("angle").forGetter(recipe -> recipe.angle), (App)Codec.DOUBLE.fieldOf("size").forGetter(recipe -> recipe.size)).apply((Applicative)instance, (name, systemStr, textureStr, angle, size) -> {
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("star_" + name)) {
            SpaceInit.regStar.add(() -> new Star((String)name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, (int)angle, (double)size));
            PlanetSerializer.stringList.add("star_" + name);
        }
        return new StarRecipe((String)name, (String)systemStr, (String)textureStr, (Integer)angle, (Double)size);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, StarRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.name, (StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.systemName, (StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.texturePath, (StreamCodec)ByteBufCodecs.VAR_INT, recipe -> recipe.angle, (StreamCodec)ByteBufCodecs.DOUBLE, recipe -> recipe.size, (name, systemStr, textureStr, angle, size) -> {
        ISystem system = SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr));
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("star_" + name)) {
            SpaceInit.regStar.add(() -> new Star((String)name, system, texture, (int)angle, (double)size));
            PlanetSerializer.stringList.add("star_" + name);
        }
        return new StarRecipe((String)name, (String)systemStr, (String)textureStr, (Integer)angle, (Double)size);
    });

    public MapCodec<StarRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, StarRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

