/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.api.space.BaseResource;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.SpaceBodyRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class SpaceBodySerializer
implements RecipeSerializer<SpaceBodyRecipe> {
    public static final StreamCodec<RegistryFriendlyByteBuf, SpaceBodyRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        buf.writeUtf(recipe.bodyName);
        buf.writeVarInt(recipe.percent.intValue());
        buf.writeVarInt(recipe.chance.intValue());
        buf.writeUtf(recipe.roverType);
        buf.writeUtf(recipe.operationType);
        buf.writeVarInt(recipe.input.size());
        for (IInputItemStack inputStack : recipe.input) {
            if (inputStack instanceof InputItemStack) {
                InputItemStack stack = (InputItemStack)inputStack;
                buf.writeUtf("item");
                buf.writeUtf(BuiltInRegistries.ITEM.getKey((Object)stack.input.getItem()).toString());
                buf.writeVarInt(stack.input.getCount());
                continue;
            }
            if (inputStack instanceof InputFluidStack) {
                InputFluidStack fluid = (InputFluidStack)inputStack;
                buf.writeUtf("fluid");
                buf.writeUtf(BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid().getFluid()).toString());
                buf.writeVarInt(fluid.getFluid().getAmount());
                continue;
            }
            if (inputStack instanceof InputOreDict) {
                InputOreDict ore = (InputOreDict)inputStack;
                buf.writeUtf("tag");
                buf.writeUtf(ore.getTag().location().toString());
                buf.writeVarInt(ore.getInputs().get(0).getCount());
                continue;
            }
            throw new IllegalArgumentException("Unknown input type: " + String.valueOf(inputStack));
        }
    }, buf -> {
        String bodyName = buf.readUtf();
        int percent = buf.readVarInt();
        int chance = buf.readVarInt();
        String typeRover = buf.readUtf();
        String typeOperation = buf.readUtf();
        int size = buf.readVarInt();
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        block22: for (int i = 0; i < size; ++i) {
            String type = buf.readUtf();
            String id = buf.readUtf();
            int amount = buf.readVarInt();
            switch (type) {
                case "item": {
                    inputs.add(new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id)), amount)));
                    continue block22;
                }
                case "fluid": {
                    inputs.add(new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)id)), amount)));
                    continue block22;
                }
                case "tag": {
                    inputs.add(new InputOreDict(id, amount));
                    continue block22;
                }
                default: {
                    throw new IllegalArgumentException("Unknown input type: " + type);
                }
            }
        }
        if (!IUCore.updateRecipe && typeRover.equals("add")) {
            switch (typeOperation) {
                case "rover": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                    }
                    break;
                }
                case "probe": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                    }
                    break;
                }
                case "satellite": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                    }
                    break;
                }
                case "rocket": {
                    for (IInputItemStack itemStack : inputs) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), chance, 100, percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                    }
                    break;
                }
            }
        }
        return new SpaceBodyRecipe(bodyName, percent, chance, typeRover, typeOperation, inputs);
    });
    static Codec<IInputItemStack> singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
        if ("fluid".equals(type)) {
            return new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amt.intValue()));
        }
        if ("tag".equals(type)) {
            return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
        }
        return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
    }));
    public static final MapCodec<SpaceBodyRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("body").forGetter(SpaceBodyRecipe::bodyName), (App)Codec.INT.fieldOf("percent").forGetter(SpaceBodyRecipe::percent), (App)Codec.INT.fieldOf("chance").forGetter(SpaceBodyRecipe::chance), (App)Codec.STRING.fieldOf("typeRover").forGetter(SpaceBodyRecipe::typeRover), (App)Codec.STRING.fieldOf("typeOperation").forGetter(SpaceBodyRecipe::typeOperation), (App)Codec.list(singleInputCodec).fieldOf("inputs").forGetter(SpaceBodyRecipe::getInputs)).apply((Applicative)instance, (bodyName, percent, chance, roverType, operationType, input) -> {
        if (operationType.equals("add")) {
            switch (roverType) {
                case "rover": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROVERS));
                    }
                    break;
                }
                case "probe": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.PROBE));
                    }
                    break;
                }
                case "satellite": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(itemStack.getInputs().get(0), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.SATELLITE));
                    }
                    break;
                }
                case "rocket": {
                    for (IInputItemStack itemStack : input) {
                        if (itemStack instanceof InputItemStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputItemStack)itemStack).input, (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (itemStack instanceof InputFluidStack) {
                            SpaceInit.regBaseResource.add(() -> new BaseResource(((InputFluidStack)itemStack).getFluid(), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                        }
                        if (!(itemStack instanceof InputOreDict)) continue;
                        SpaceInit.regBaseResource.add(() -> new BaseResource(((InputOreDict)itemStack).getInputs().get(0), (int)chance, 100, (int)percent, SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), EnumTypeRovers.ROCKET));
                    }
                    break;
                }
            }
        }
        return new SpaceBodyRecipe((String)bodyName, (Integer)percent, (Integer)chance, (String)roverType, (String)operationType, (List<IInputItemStack>)input);
    }));

    public MapCodec<SpaceBodyRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SpaceBodyRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

