/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.smeltery.BlockEntitySmelteryController;
import com.denfop.blockentity.smeltery.BlockEntitySmelteryFurnace;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.SmelteryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class SmelterSerializer
implements RecipeSerializer<SmelteryRecipe> {
    public static final MapCodec<SmelteryRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> {
        Codec singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
            if ("tag".equals(type)) {
                return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
            }
            if ("fluid".equals(type)) {
                return new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amt.intValue()));
            }
            return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
        }));
        return builder.group((App)Codec.STRING.fieldOf("operation").forGetter(SmelteryRecipe::getOperation), (App)Codec.list((Codec)singleInputCodec).fieldOf("inputs").forGetter(SmelteryRecipe::getInputs), (App)Codec.list((Codec)singleInputCodec).fieldOf("outputs").forGetter(SmelteryRecipe::getOutputs)).apply((Applicative)builder, (operation, inputs, outputs) -> {
            ArrayList<FluidStack> fluidStacksInput = new ArrayList<FluidStack>();
            ArrayList<ItemStack> itemStacksInput = new ArrayList<ItemStack>();
            ArrayList<FluidStack> fluidStacksOutput = new ArrayList<FluidStack>();
            ArrayList<ItemStack> itemStacksOutput = new ArrayList<ItemStack>();
            for (IInputItemStack o : inputs) {
                if (o instanceof InputFluidStack) {
                    fluidStacksInput.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                itemStacksInput.add(o.getInputs().get(0));
            }
            for (IInputItemStack o : outputs) {
                if (o instanceof InputFluidStack) {
                    fluidStacksOutput.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                itemStacksOutput.add(o.getInputs().get(0));
            }
            switch (operation) {
                case "furnace": {
                    ItemStack stack = (ItemStack)itemStacksInput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksOutput.get(0);
                    if (stack == null || fluidStack == null) break;
                    BlockEntitySmelteryFurnace.addRecipe("", stack, fluidStack);
                    break;
                }
                case "castings_ingot": {
                    ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                    Recipes.recipes.getRecipeFluid().addRecipe("ingot_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                    break;
                }
                case "castings_gear": {
                    ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                    Recipes.recipes.getRecipeFluid().addRecipe("gear_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                    break;
                }
                case "mix": {
                    FluidStack fluidStack1 = (FluidStack)fluidStacksOutput.get(0);
                    ArrayList<FluidStack> list = fluidStacksInput;
                    BlockEntitySmelteryController.mapRecipes.put(list, fluidStack1);
                }
            }
            return new SmelteryRecipe((String)operation, (List<IInputItemStack>)inputs, (List<IInputItemStack>)outputs);
        });
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, SmelteryRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        buf.writeUtf(recipe.getOperation());
        buf.writeVarInt(recipe.getInputs().size());
        for (IInputItemStack input : recipe.getInputs()) {
            if (input instanceof InputFluidStack) {
                buf.writeUtf("fluid");
                buf.writeResourceLocation(BuiltInRegistries.FLUID.getKey((Object)((InputFluidStack)input).getFluid().getFluid()));
                buf.writeVarInt(((InputFluidStack)input).getFluid().getAmount());
                continue;
            }
            if (input instanceof InputOreDict) {
                buf.writeUtf("tag");
                buf.writeUtf(input.getTag().location().toString());
                buf.writeVarInt(input.getAmount());
                continue;
            }
            if (!(input instanceof InputItemStack)) continue;
            buf.writeUtf("item");
            buf.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)((InputItemStack)input).input.getItem()));
            buf.writeVarInt(input.getAmount());
        }
        buf.writeVarInt(recipe.getOutputs().size());
        for (IInputItemStack output : recipe.getOutputs()) {
            if (output instanceof InputFluidStack) {
                buf.writeUtf("fluid");
                buf.writeResourceLocation(BuiltInRegistries.FLUID.getKey((Object)((InputFluidStack)output).getFluid().getFluid()));
                buf.writeVarInt(((InputFluidStack)output).getFluid().getAmount());
                continue;
            }
            if (output instanceof InputOreDict) {
                buf.writeUtf("tag");
                buf.writeUtf(output.getTag().location().toString());
                buf.writeVarInt(output.getAmount());
                continue;
            }
            if (!(output instanceof InputItemStack)) continue;
            buf.writeUtf("item");
            buf.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)((InputItemStack)output).input.getItem()));
            buf.writeVarInt(output.getAmount());
        }
    }, buf -> {
        String operation = buf.readUtf();
        int inSize = buf.readVarInt();
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        block32: for (int i = 0; i < inSize; ++i) {
            String type;
            switch (type = buf.readUtf()) {
                case "fluid": {
                    Object fluidId = buf.readResourceLocation();
                    int amountF = buf.readVarInt();
                    inputs.add(new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get((ResourceLocation)fluidId), amountF)));
                    continue block32;
                }
                case "tag": {
                    String tag = buf.readUtf();
                    int amountT = buf.readVarInt();
                    inputs.add(new InputOreDict(tag, amountT));
                    continue block32;
                }
                case "item": {
                    ResourceLocation itemId = buf.readResourceLocation();
                    int amountI = buf.readVarInt();
                    inputs.add(new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemId), amountI)));
                }
            }
        }
        int outSize = buf.readVarInt();
        ArrayList<IInputItemStack> outputs = new ArrayList<IInputItemStack>();
        block33: for (int i = 0; i < outSize; ++i) {
            String type = buf.readUtf();
            switch (type) {
                case "fluid": {
                    ResourceLocation fluidId = buf.readResourceLocation();
                    int amountF = buf.readVarInt();
                    outputs.add(new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(fluidId), amountF)));
                    continue block33;
                }
                case "tag": {
                    String tag = buf.readUtf();
                    int amountT = buf.readVarInt();
                    outputs.add(new InputOreDict(tag, amountT));
                    continue block33;
                }
                case "item": {
                    ResourceLocation itemId = buf.readResourceLocation();
                    int amountI = buf.readVarInt();
                    inputs.add(new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemId), amountI)));
                }
            }
        }
        if (!IUCore.updateRecipe) {
            ArrayList<FluidStack> fluidStacksInput = new ArrayList<FluidStack>();
            ArrayList<ItemStack> itemStacksInput = new ArrayList<ItemStack>();
            ArrayList<FluidStack> fluidStacksOutput = new ArrayList<FluidStack>();
            ArrayList<ItemStack> itemStacksOutput = new ArrayList<ItemStack>();
            for (IInputItemStack o : inputs) {
                if (o instanceof InputFluidStack) {
                    fluidStacksInput.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                itemStacksInput.add(o.getInputs().get(0));
            }
            for (IInputItemStack o : outputs) {
                if (o instanceof InputFluidStack) {
                    fluidStacksOutput.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                itemStacksOutput.add(o.getInputs().get(0));
            }
            switch (operation) {
                case "furnace": {
                    ItemStack stack = (ItemStack)itemStacksInput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksOutput.get(0);
                    if (stack == null || fluidStack == null) break;
                    BlockEntitySmelteryFurnace.addRecipe("", stack, fluidStack);
                    break;
                }
                case "castings_ingot": {
                    ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                    Recipes.recipes.getRecipeFluid().addRecipe("ingot_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                    break;
                }
                case "castings_gear": {
                    ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                    FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                    Recipes.recipes.getRecipeFluid().addRecipe("gear_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                    break;
                }
                case "mix": {
                    FluidStack fluidStack1 = (FluidStack)fluidStacksOutput.get(0);
                    ArrayList<FluidStack> list = fluidStacksInput;
                    BlockEntitySmelteryController.mapRecipes.put(list, fluidStack1);
                }
            }
        }
        return new SmelteryRecipe(operation, inputs, outputs);
    });

    public MapCodec<SmelteryRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SmelteryRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

