/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.Satellite;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.denfop.recipe.universalrecipe.SatelliteRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SatelliteSerializer
implements RecipeSerializer<SatelliteRecipe> {
    public static final MapCodec<SatelliteRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(s -> s.name), (App)Codec.STRING.fieldOf("system").forGetter(s -> s.systemName), (App)Codec.STRING.fieldOf("texture").forGetter(s -> s.texturePath), (App)Codec.STRING.xmap(str -> EnumLevels.valueOf(str.toUpperCase()), Enum::name).fieldOf("level").forGetter(s -> s.level), (App)Codec.STRING.fieldOf("planet").forGetter(s -> s.planetName), (App)Codec.INT.fieldOf("temperature").forGetter(s -> s.temperature), (App)Codec.BOOL.fieldOf("pressure").forGetter(s -> s.pressure), (App)Codec.DOUBLE.fieldOf("distance").forGetter(s -> s.distance), (App)Codec.STRING.xmap(str -> EnumType.valueOf(str.toUpperCase()), Enum::name).fieldOf("type").forGetter(s -> s.type), (App)Codec.BOOL.fieldOf("oxygen").forGetter(s -> s.oxygen), (App)Codec.BOOL.fieldOf("colonies").forGetter(s -> s.colonies), (App)Codec.INT.fieldOf("angle").forGetter(s -> s.angle), (App)Codec.DOUBLE.fieldOf("time").forGetter(s -> s.time), (App)Codec.DOUBLE.fieldOf("size").forGetter(s -> s.size), (App)Codec.DOUBLE.fieldOf("rotation").forGetter(s -> s.rotation)).apply((Applicative)instance, (name, systemStr, textureStr, level, planetStr, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation) -> {
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("satellite_" + name)) {
            SpaceInit.regSatellite.add(() -> new Satellite((String)name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, (EnumLevels)((Object)((Object)level)), (IPlanet)SpaceNet.instance.getBodyFromName((String)planetStr), (int)temperature, (boolean)pressure, (double)distance, (EnumType)((Object)((Object)type)), (boolean)oxygen, (boolean)colonies, (int)angle, (double)time, (double)size, (double)rotation));
            PlanetSerializer.stringList.add("satellite_" + name);
        }
        return new SatelliteRecipe((String)name, (String)systemStr, (String)textureStr, (EnumLevels)((Object)((Object)level)), (String)planetStr, (Integer)temperature, (Boolean)pressure, (Double)distance, (EnumType)((Object)((Object)type)), (Boolean)oxygen, (Boolean)colonies, (Integer)angle, (Double)time, (Double)size, (Double)rotation);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, SatelliteRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.name);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.systemName);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.texturePath);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.level.name());
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.planetName);
        ByteBufCodecs.VAR_INT.encode(buf, (Object)recipe.temperature);
        ByteBufCodecs.BOOL.encode(buf, (Object)recipe.pressure);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.distance);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.type.name());
        ByteBufCodecs.BOOL.encode(buf, (Object)recipe.oxygen);
        ByteBufCodecs.BOOL.encode(buf, (Object)recipe.colonies);
        ByteBufCodecs.VAR_INT.encode(buf, (Object)recipe.angle);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.time);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.size);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.rotation);
    }, buf -> {
        String name = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        String system1 = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        String textureStr = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        EnumLevels level = EnumLevels.valueOf(((String)ByteBufCodecs.STRING_UTF8.decode(buf)).toUpperCase());
        String planetStr = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        int temperature = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        boolean pressure = (Boolean)ByteBufCodecs.BOOL.decode(buf);
        double distance = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        EnumType type = EnumType.valueOf(((String)ByteBufCodecs.STRING_UTF8.decode(buf)).toUpperCase());
        boolean oxygen = (Boolean)ByteBufCodecs.BOOL.decode(buf);
        boolean colonies = (Boolean)ByteBufCodecs.BOOL.decode(buf);
        int angle = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        double time = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double size = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double rotation = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("satellite_" + name)) {
            SpaceInit.regSatellite.add(() -> new Satellite(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(system1.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + system1)), texture, level, (IPlanet)SpaceNet.instance.getBodyFromName(planetStr), temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation));
            PlanetSerializer.stringList.add("satellite_" + name);
        }
        return new SatelliteRecipe(name, system1, textureStr, level, planetStr, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation);
    });

    public MapCodec<SatelliteRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SatelliteRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

