/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.QuantumQuarryRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class QuantumQuarrySerializer
implements RecipeSerializer<QuantumQuarryRecipe> {
    public static final MapCodec<QuantumQuarryRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> {
        Codec singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
            if ("tag".equals(type)) {
                return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
            }
            return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
        }));
        return builder.group((App)Codec.STRING.fieldOf("recipe_type").forGetter(QuantumQuarryRecipe::getRecipeType), (App)Codec.STRING.fieldOf("recipeOperation").forGetter(QuantumQuarryRecipe::getTypeOperation), (App)Codec.list((Codec)singleInputCodec).fieldOf("inputs").forGetter(QuantumQuarryRecipe::getInputs)).apply((Applicative)builder, (recipeType, recipeOperation, inputs) -> {
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            for (IInputItemStack o : inputs) {
                input.add(o.getInputs().get(0));
            }
            block6 : switch (recipeOperation) {
                case "default": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "furnace": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_furnace_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_furnace_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "macerator": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_crushed_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_crushed_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "comb_macerator": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_comb_crushed_adding.addAll(input);
                            break block6;
                        }
                        case "remove": {
                            IUCore.list_comb_crushed_removing.addAll(input);
                        }
                    }
                }
            }
            return new QuantumQuarryRecipe((String)recipeType, (String)recipeOperation, (List<IInputItemStack>)inputs);
        });
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, QuantumQuarryRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        buf.writeUtf(recipe.getRecipeType());
        buf.writeUtf(recipe.getTypeOperation());
        buf.writeVarInt(recipe.getInputs().size());
        for (IInputItemStack stack : recipe.getInputs()) {
            if (stack instanceof InputItemStack) {
                InputItemStack itemStack = (InputItemStack)stack;
                buf.writeUtf("item");
                buf.writeResourceLocation(BuiltInRegistries.ITEM.getKey((Object)itemStack.input.getItem()));
                buf.writeVarInt(itemStack.input.getCount());
                continue;
            }
            if (stack instanceof InputOreDict) {
                InputOreDict oreDict = (InputOreDict)stack;
                buf.writeUtf("tag");
                buf.writeUtf(oreDict.getTag().location().toString());
                buf.writeVarInt(oreDict.getInputs().get(0).getCount());
                continue;
            }
            if (stack instanceof InputFluidStack) {
                InputFluidStack fluidStack = (InputFluidStack)stack;
                buf.writeUtf("fluid");
                buf.writeResourceLocation(BuiltInRegistries.FLUID.getKey((Object)fluidStack.getFluid().getFluid()));
                buf.writeVarInt(fluidStack.getFluid().getAmount());
                continue;
            }
            throw new IllegalArgumentException("Unknown input type: " + String.valueOf(stack));
        }
    }, buf -> {
        String recipeType = buf.readUtf();
        String recipeOperation = buf.readUtf();
        int size = buf.readVarInt();
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        block54: for (int i = 0; i < size; ++i) {
            String type;
            switch (type = buf.readUtf()) {
                case "item": {
                    ResourceLocation itemId = buf.readResourceLocation();
                    int amount = buf.readVarInt();
                    ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemId), amount);
                    inputs.add(new InputItemStack(itemStack));
                    continue block54;
                }
                case "tag": {
                    String tagId = buf.readUtf();
                    int amount = buf.readVarInt();
                    inputs.add(new InputOreDict(tagId, amount));
                    continue block54;
                }
                case "fluid": {
                    ResourceLocation fluidId = buf.readResourceLocation();
                    int amount = buf.readVarInt();
                    FluidStack fluidStack = new FluidStack((Fluid)BuiltInRegistries.FLUID.get(fluidId), amount);
                    inputs.add(new InputFluidStack(fluidStack));
                    continue block54;
                }
                default: {
                    throw new IllegalArgumentException("Unknown input type: " + type);
                }
            }
        }
        if (!IUCore.updateRecipe) {
            ArrayList<ItemStack> input = new ArrayList<ItemStack>();
            for (IInputItemStack o : inputs) {
                input.add(o.getInputs().get(0));
            }
            block16 : switch (recipeOperation) {
                case "default": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "furnace": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_furnace_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_furnace_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "macerator": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_crushed_adding.addAll(input);
                            break;
                        }
                        case "remove": {
                            IUCore.list_crushed_removing.addAll(input);
                        }
                    }
                    break;
                }
                case "comb_macerator": {
                    switch (recipeOperation) {
                        case "add": {
                            IUCore.list_comb_crushed_adding.addAll(input);
                            break block16;
                        }
                        case "remove": {
                            IUCore.list_comb_crushed_removing.addAll(input);
                        }
                    }
                }
            }
        }
        return new QuantumQuarryRecipe(recipeType, recipeOperation, inputs);
    });

    public MapCodec<QuantumQuarryRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, QuantumQuarryRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

