/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IStar;
import com.denfop.api.space.Planet;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.PlanetRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class PlanetSerializer
implements RecipeSerializer<PlanetRecipe> {
    public static List<String> stringList = new ArrayList<String>();
    public static final MapCodec<PlanetRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(p -> p.name), (App)Codec.STRING.fieldOf("system").forGetter(p -> p.systemName), (App)Codec.STRING.fieldOf("texture").forGetter(p -> p.texturePath), (App)Codec.STRING.xmap(EnumLevels::valueOf, Enum::name).fieldOf("level").forGetter(p -> p.level), (App)Codec.STRING.fieldOf("star").forGetter(p -> p.starName), (App)Codec.INT.fieldOf("temperature").forGetter(p -> p.temperature), (App)Codec.BOOL.fieldOf("pressure").forGetter(p -> p.pressure), (App)Codec.DOUBLE.fieldOf("distance").forGetter(p -> p.distance), (App)Codec.STRING.xmap(EnumType::valueOf, Enum::name).fieldOf("type").forGetter(p -> p.type), (App)Codec.BOOL.fieldOf("oxygen").forGetter(p -> p.oxygen), (App)Codec.BOOL.fieldOf("colonies").forGetter(p -> p.colonies), (App)Codec.INT.fieldOf("angle").forGetter(p -> p.angle), (App)Codec.DOUBLE.fieldOf("time").forGetter(p -> p.time), (App)Codec.DOUBLE.fieldOf("size").forGetter(p -> p.size), (App)Codec.DOUBLE.fieldOf("rotation").forGetter(p -> p.rotation)).apply((Applicative)instance, (name, systemStr, textureStr, levelStr, starStr, temp, pressure, distance, typeStr, oxygen, colonies, angle, time, size, rotation) -> {
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        if (!stringList.contains("planet_" + name)) {
            SpaceInit.regPlanet.add(() -> new Planet((String)name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, (EnumLevels)((Object)((Object)levelStr)), (IStar)SpaceNet.instance.getBodyFromName((String)starStr), (int)temp, (boolean)pressure, (double)distance, (EnumType)((Object)((Object)typeStr)), (boolean)oxygen, (boolean)colonies, (int)angle, (double)time, (double)size, (double)rotation));
            stringList.add("planet_" + name);
        }
        return new PlanetRecipe((String)name, (String)systemStr, (String)textureStr, (EnumLevels)((Object)((Object)levelStr)), (String)starStr, (Integer)temp, (Boolean)pressure, (Double)distance, (EnumType)((Object)((Object)typeStr)), (Boolean)oxygen, (Boolean)colonies, (Integer)angle, (Double)time, (Double)size, (Double)rotation);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, PlanetRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.name);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.systemName);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.texturePath);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.level.name());
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.starName);
        ByteBufCodecs.VAR_INT.encode(buf, (Object)recipe.temperature);
        ByteBufCodecs.BOOL.encode(buf, (Object)recipe.pressure);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.distance);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.type.name());
        ByteBufCodecs.BOOL.encode(buf, (Object)recipe.oxygen);
        ByteBufCodecs.BOOL.encode(buf, (Object)recipe.colonies);
        ByteBufCodecs.VAR_INT.encode(buf, (Object)recipe.angle);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.time);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.size);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.rotation);
    }, buf -> {
        String name = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        String systemStr = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        String textureStr = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        EnumLevels level = EnumLevels.valueOf((String)ByteBufCodecs.STRING_UTF8.decode(buf));
        String starStr = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        int temp = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        boolean pressure = (Boolean)ByteBufCodecs.BOOL.decode(buf);
        double distance = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        EnumType typeStr = EnumType.valueOf((String)ByteBufCodecs.STRING_UTF8.decode(buf));
        boolean oxygen = (Boolean)ByteBufCodecs.BOOL.decode(buf);
        boolean colonies = (Boolean)ByteBufCodecs.BOOL.decode(buf);
        int angle = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        double time = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double size = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double rotation = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        if (!stringList.contains("planet_" + name)) {
            SpaceInit.regPlanet.add(() -> new Planet(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, level, (IStar)SpaceNet.instance.getBodyFromName(starStr), temp, pressure, distance, typeStr, oxygen, colonies, angle, time, size, rotation));
            stringList.add("planet_" + name);
        }
        return new PlanetRecipe(name, systemStr, textureStr, level, starStr, temp, pressure, distance, typeStr, oxygen, colonies, angle, time, size, rotation);
    });

    public MapCodec<PlanetRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, PlanetRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

