/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.IURecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class IURecipeSerializer
implements RecipeSerializer<IURecipe> {
    public static final MapCodec<IURecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> {
        Codec singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
            if ("fluid".equals(type)) {
                return new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amt.intValue()));
            }
            if ("tag".equals(type)) {
                return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
            }
            return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
        }));
        Codec singleOutputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(o -> o instanceof FluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(o -> o instanceof FluidStack ? BuiltInRegistries.FLUID.getKey((Object)((FluidStack)o).getFluid()) : BuiltInRegistries.ITEM.getKey((Object)((ItemStack)o).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(o -> o instanceof FluidStack ? ((FluidStack)o).getAmount() : ((ItemStack)o).getCount())).apply((Applicative)inst, (type, id, amt) -> {
            if ("fluid".equals(type)) {
                return new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amt.intValue());
            }
            return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue());
        }));
        return builder.group((App)Codec.STRING.fieldOf("recipe_type").forGetter(IURecipe::getRecipeType), (App)Codec.BOOL.optionalFieldOf("isFluidRecipe", (Object)false).forGetter(IURecipe::isFluid), (App)Codec.list((Codec)singleInputCodec).fieldOf("inputs").forGetter(IURecipe::getInputs), (App)Codec.list((Codec)singleOutputCodec).fieldOf("outputs").forGetter(r -> Collections.singletonList(r.getOutputs())), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.either((Codec)Codec.STRING, (Codec)Codec.DOUBLE)).xmap(m -> {
            HashMap res = new HashMap();
            m.forEach((k, v) -> res.put(k, v.map(left -> left, right -> right)));
            return res;
        }, m -> {
            HashMap enc = new HashMap();
            m.forEach((k, v) -> {
                if (v instanceof String) {
                    enc.put(k, Either.left((Object)((String)v)));
                } else if (v instanceof Number) {
                    enc.put(k, Either.right((Object)((Number)v).doubleValue()));
                }
            });
            return enc;
        }).fieldOf("params").forGetter(IURecipe::getParams)).apply((Applicative)builder, (recipeType, isFluidRecipe, inputs1, outputs, params) -> {
            ArrayList<ItemStack> outputs1 = new ArrayList<ItemStack>();
            ArrayList<FluidStack> outputsFluid = new ArrayList<FluidStack>();
            for (Object o : outputs) {
                if (o instanceof FluidStack) {
                    outputsFluid.add((FluidStack)o);
                    continue;
                }
                outputs1.add((ItemStack)o);
            }
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry entry : params.entrySet()) {
                if (entry.getValue() instanceof Boolean) {
                    compoundTag.putBoolean((String)entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                }
                if (!(entry.getValue() instanceof Number)) continue;
                compoundTag.putDouble((String)entry.getKey(), ((Number)entry.getValue()).doubleValue());
            }
            ArrayList<FluidStack> fluidStacks = new ArrayList<FluidStack>();
            ArrayList<IInputItemStack> arrayList = new ArrayList<IInputItemStack>();
            for (IInputItemStack o : inputs1) {
                if (o instanceof InputFluidStack) {
                    fluidStacks.add(((InputFluidStack)o).getFluid());
                    continue;
                }
                arrayList.add(o);
            }
            if (!arrayList.isEmpty() && fluidStacks.isEmpty()) {
                Recipes.recipes.addAdderRecipe((String)recipeType, new BaseMachineRecipe(new Input(arrayList), new RecipeOutput(compoundTag, outputs1)));
            } else if (!arrayList.isEmpty() && !isFluidRecipe.booleanValue()) {
                Recipes.recipes.addAdderRecipe((String)recipeType, new BaseMachineRecipe(new Input((FluidStack)fluidStacks.get(0), arrayList), new RecipeOutput(compoundTag, outputs1)));
            } else if (arrayList.isEmpty() && isFluidRecipe.booleanValue()) {
                if (!outputs1.isEmpty() && outputsFluid.isEmpty()) {
                    Recipes.recipes.addFluidAdderRecipe((String)recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1)));
                } else if (!outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                    Recipes.recipes.addFluidAdderRecipe((String)recipeType, new BaseFluidMachineRecipe(new InputFluid(fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1), outputsFluid));
                } else if (outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                    Recipes.recipes.addFluidAdderRecipe((String)recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStacks.toArray(new FluidStack[0])), outputsFluid));
                }
            } else if (!arrayList.isEmpty() && isFluidRecipe.booleanValue()) {
                Recipes.recipes.addAdderRecipe((String)recipeType, new BaseMachineRecipe(new Input((FluidStack)fluidStacks.get(0), arrayList), new RecipeOutput(compoundTag, outputs1)));
                if (!outputs1.isEmpty() && outputsFluid.isEmpty()) {
                    Recipes.recipes.addFluidAdderRecipe((String)recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(((IInputItemStack)arrayList.get(0)).getInputs().get(0), fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1)));
                } else if (!outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                    Recipes.recipes.addFluidAdderRecipe((String)recipeType, new BaseFluidMachineRecipe(new InputFluid(((IInputItemStack)arrayList.get(0)).getInputs().get(0), fluidStacks.toArray(new FluidStack[0])), new RecipeOutput(compoundTag, outputs1), outputsFluid));
                } else if (outputs1.isEmpty() && !outputsFluid.isEmpty()) {
                    Recipes.recipes.addFluidAdderRecipe((String)recipeType, new BaseFluidMachineRecipe((IInputFluid)new InputFluid(((IInputItemStack)arrayList.get(0)).getInputs().get(0), fluidStacks.toArray(new FluidStack[0])), outputsFluid));
                }
            }
            return new IURecipe((String)recipeType, (Boolean)isFluidRecipe, (List<IInputItemStack>)arrayList, (List<FluidStack>)fluidStacks, (List<ItemStack>)outputs1, (List<FluidStack>)outputsFluid, (Map<String, Object>)params);
        });
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, IURecipe> STREAM_CODEC = StreamCodec.of(IURecipeSerializer::toNetwork, IURecipeSerializer::fromNetwork);

    private static IURecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
        return new IURecipe("", false, new ArrayList<IInputItemStack>(), new ArrayList<FluidStack>(), new ArrayList<ItemStack>(), new ArrayList<FluidStack>(), new HashMap<String, Object>());
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, IURecipe p_320586_) {
    }

    public MapCodec<IURecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, IURecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

