/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.ColonyRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class ColonySerializer
implements RecipeSerializer<ColonyRecipe> {
    public static final StreamCodec<RegistryFriendlyByteBuf, ColonyRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        buf.writeUtf(recipe.bodyName);
        buf.writeVarInt(recipe.level);
        buf.writeVarInt(recipe.input.size());
        for (IInputItemStack inputStack : recipe.input) {
            if (inputStack instanceof InputItemStack) {
                InputItemStack stack = (InputItemStack)inputStack;
                buf.writeUtf("item");
                buf.writeUtf(BuiltInRegistries.ITEM.getKey((Object)stack.input.getItem()).toString());
                buf.writeVarInt(stack.input.getCount());
                continue;
            }
            if (inputStack instanceof InputFluidStack) {
                InputFluidStack fluid = (InputFluidStack)inputStack;
                buf.writeUtf("fluid");
                buf.writeUtf(BuiltInRegistries.FLUID.getKey((Object)fluid.getFluid().getFluid()).toString());
                buf.writeVarInt(fluid.getFluid().getAmount());
                continue;
            }
            if (inputStack instanceof InputOreDict) {
                InputOreDict ore = (InputOreDict)inputStack;
                buf.writeUtf("tag");
                buf.writeUtf(ore.getTag().location().toString());
                buf.writeVarInt(ore.getInputs().get(0).getCount());
                continue;
            }
            throw new IllegalArgumentException("Unknown input type: " + String.valueOf(inputStack));
        }
    }, buf -> {
        String bodyName = buf.readUtf();
        int level = buf.readVarInt();
        int size = buf.readVarInt();
        ArrayList<IInputItemStack> inputs = new ArrayList<IInputItemStack>();
        block10: for (int i = 0; i < size; ++i) {
            String type = buf.readUtf();
            String id = buf.readUtf();
            int amount = buf.readVarInt();
            switch (type) {
                case "item": {
                    inputs.add(new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)id)), amount)));
                    continue block10;
                }
                case "fluid": {
                    inputs.add(new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)id)), amount)));
                    continue block10;
                }
                case "tag": {
                    inputs.add(new InputOreDict(id, amount));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException("Unknown input type: " + type);
                }
            }
        }
        if (!IUCore.updateRecipe) {
            for (IInputItemStack itemStack : inputs) {
                if (itemStack instanceof InputItemStack) {
                    SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addItemStack(SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), level, ((InputItemStack)itemStack).input));
                }
                if (itemStack instanceof InputFluidStack) {
                    SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addFluidStack(SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), level, ((InputFluidStack)itemStack).getFluid()));
                }
                if (!(itemStack instanceof InputOreDict)) continue;
                SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addItemStack(SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), level, itemStack.getInputs().get(0)));
            }
        }
        return new ColonyRecipe(bodyName, inputs, level);
    });
    static Codec<IInputItemStack> singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
        if ("fluid".equals(type)) {
            return new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amt.intValue()));
        }
        if ("tag".equals(type)) {
            return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
        }
        return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
    }));
    public static final MapCodec<ColonyRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("body").forGetter(c -> c.bodyName), (App)Codec.INT.fieldOf("level").forGetter(c -> c.level), (App)Codec.list(singleInputCodec).fieldOf("inputs").forGetter(ColonyRecipe::getInputs)).apply((Applicative)instance, (bodyName, level, inputs) -> {
        if (!IUCore.register) {
            for (IInputItemStack itemStack : inputs) {
                if (itemStack instanceof InputItemStack) {
                    SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addItemStack(SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), (int)level, ((InputItemStack)itemStack).input));
                }
                if (itemStack instanceof InputFluidStack) {
                    SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addFluidStack(SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), (int)level, ((InputFluidStack)itemStack).getFluid()));
                }
                if (!(itemStack instanceof InputOreDict)) continue;
                SpaceInit.regColonyBaseResource.add(() -> SpaceNet.instance.getColonieNet().addItemStack(SpaceNet.instance.getBodyFromName(bodyName.toLowerCase()), (int)level, itemStack.getInputs().get(0)));
            }
        }
        return new ColonyRecipe((String)bodyName, (List<IInputItemStack>)inputs, (int)level);
    }));

    public MapCodec<ColonyRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ColonyRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

