/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.Asteroid;
import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IStar;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.AsteroidRecipe;
import com.denfop.recipe.universalrecipe.PlanetSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AsteroidSerializer
implements RecipeSerializer<AsteroidRecipe> {
    public static final MapCodec<AsteroidRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(a -> a.name), (App)Codec.STRING.fieldOf("system").forGetter(a -> a.systemName), (App)Codec.STRING.fieldOf("texture").forGetter(a -> a.texturePath), (App)Codec.STRING.xmap(s -> EnumLevels.valueOf(s.toUpperCase()), Enum::name).fieldOf("level").forGetter(a -> a.level), (App)Codec.STRING.fieldOf("star").forGetter(a -> a.starName), (App)Codec.INT.fieldOf("temperature").forGetter(a -> a.temperature), (App)Codec.DOUBLE.fieldOf("distance").forGetter(a -> a.distance), (App)Codec.STRING.xmap(s -> EnumType.valueOf(s.toUpperCase()), Enum::name).fieldOf("type").forGetter(a -> a.type), (App)Codec.BOOL.fieldOf("colonies").forGetter(a -> a.colonies), (App)Codec.INT.fieldOf("angle").forGetter(a -> a.angle), (App)Codec.DOUBLE.fieldOf("time").forGetter(a -> a.time), (App)Codec.DOUBLE.fieldOf("size").forGetter(a -> a.size), (App)Codec.DOUBLE.fieldOf("rotation").forGetter(a -> a.rotation), (App)Codec.DOUBLE.fieldOf("minLocation").forGetter(a -> a.minLocation), (App)Codec.DOUBLE.fieldOf("maxLocation").forGetter(a -> a.maxLocation), (App)Codec.INT.fieldOf("amount").forGetter(a -> a.amount)).apply((Applicative)instance, (name, systemStr, textureStr, level, starStr, temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount) -> {
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        if (!PlanetSerializer.stringList.contains("asteroid_" + name)) {
            SpaceInit.regAsteroid.add(() -> new Asteroid((String)name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr)), texture, (EnumLevels)((Object)((Object)level)), (IStar)SpaceNet.instance.getBodyFromName((String)starStr), (int)temperature, (double)distance, (EnumType)((Object)((Object)type)), (boolean)colonies, (int)angle, (double)time, (double)size, (double)rotation, (double)minLocation, (double)maxLocation, (int)amount));
            PlanetSerializer.stringList.add("asteroid_" + name);
        }
        return new AsteroidRecipe((String)name, (String)systemStr, (String)textureStr, (EnumLevels)((Object)((Object)level)), (String)starStr, (Integer)temperature, (Double)distance, (EnumType)((Object)((Object)type)), (Boolean)colonies, (Integer)angle, (Double)time, (Double)size, (Double)rotation, (Double)minLocation, (Double)maxLocation, (Integer)amount);
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, AsteroidRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.name);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.systemName);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.texturePath);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.level.name());
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.starName);
        ByteBufCodecs.VAR_INT.encode(buf, (Object)recipe.temperature);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.distance);
        ByteBufCodecs.STRING_UTF8.encode(buf, (Object)recipe.type.name());
        ByteBufCodecs.BOOL.encode(buf, (Object)recipe.colonies);
        ByteBufCodecs.VAR_INT.encode(buf, (Object)recipe.angle);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.time);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.size);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.rotation);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.minLocation);
        ByteBufCodecs.DOUBLE.encode(buf, (Object)recipe.maxLocation);
        ByteBufCodecs.VAR_INT.encode(buf, (Object)recipe.amount);
    }, buf -> {
        String name = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        String system = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        String texture = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        EnumLevels level = EnumLevels.valueOf(((String)ByteBufCodecs.STRING_UTF8.decode(buf)).toUpperCase());
        String star = (String)ByteBufCodecs.STRING_UTF8.decode(buf);
        int temperature = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        double distance = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        EnumType type = EnumType.valueOf(((String)ByteBufCodecs.STRING_UTF8.decode(buf)).toUpperCase());
        boolean colonies = (Boolean)ByteBufCodecs.BOOL.decode(buf);
        int angle = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        double time = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double size = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double rotation = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double minLocation = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        double maxLocation = (Double)ByteBufCodecs.DOUBLE.decode(buf);
        int amount = (Integer)ByteBufCodecs.VAR_INT.decode(buf);
        if (!PlanetSerializer.stringList.contains("asteroid_" + name)) {
            SpaceInit.regAsteroid.add(() -> new Asteroid(name, SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(system.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + system)), ResourceLocation.parse((String)(texture + ".png")), level, (IStar)SpaceNet.instance.getBodyFromName(star), temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount));
            PlanetSerializer.stringList.add("asteroid_" + name);
        }
        return new AsteroidRecipe(name, system, texture, level, star, temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount);
    });

    public MapCodec<AsteroidRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, AsteroidRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

