/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.api.item.energy.EnergyItem;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InputItemStack
implements IInputItemStack {
    public static InputItemStack EMPTY = new InputItemStack(ItemStack.EMPTY, 1, true);
    public final ItemStack input;
    public int amount;

    public InputItemStack(CompoundTag compoundTag, HolderLookup.Provider provider) {
        boolean exist = compoundTag.getBoolean("exist");
        if (exist) {
            this.input = ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compoundTag.getCompound("input"));
            this.amount = compoundTag.getInt("amount");
        } else {
            this.input = ItemStack.EMPTY;
            this.amount = 1;
        }
    }

    public InputItemStack(ItemStack input) {
        this(input, ModUtils.getSize(input));
    }

    public InputItemStack(ItemStack input, int amount) {
        this.input = input.copy();
        this.amount = amount;
    }

    InputItemStack(ItemStack input, int amount, boolean f) {
        this.input = input.copy();
        this.amount = amount;
    }

    public static IInputItemStack create(CompoundTag tag, HolderLookup.Provider provider) {
        byte id = tag.getByte("id");
        if (id == 0) {
            return new InputItemStack(tag, provider);
        }
        if (id == 1) {
            return new InputOreDict(tag, provider);
        }
        return new InputFluidStack(tag, provider);
    }

    @Override
    public void growAmount(int col) {
        ++this.amount;
        this.input.setCount(this.amount);
    }

    @Override
    public boolean matches(ItemStack subject) {
        boolean energy = this.input.getItem() instanceof EnergyItem && subject.getItem() instanceof EnergyItem;
        return subject.getItem() == this.input.getItem() && ModUtils.checkItemEquality(this.input, subject);
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.singletonList(ModUtils.setSize(this.input, this.getAmount()));
    }

    @Override
    public boolean hasTag() {
        return false;
    }

    @Override
    public TagKey<Item> getTag() {
        return null;
    }

    public String toString() {
        return "RInputItemStack<" + String.valueOf(ModUtils.setSize(this.input, this.amount)) + ">";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == null) return false;
        if (this.getClass() != obj.getClass()) return false;
        InputItemStack other = (InputItemStack)obj;
        if (!this.matches(other.input)) return false;
        if (other.amount != this.amount) return false;
        return true;
    }

    @Override
    public CompoundTag writeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putByte("id", (byte)0);
        compoundTag.putBoolean("exist", this.input != null && !this.input.isEmpty());
        if (this.input != null && !this.input.isEmpty()) {
            compoundTag.putInt("amount", this.amount);
            compoundTag.put("input", this.input.save(provider, (Tag)new CompoundTag()));
        }
        return compoundTag;
    }
}

