/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PacketUpdateBookMarks
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketUpdateBookMarks() {
    }

    public PacketUpdateBookMarks(DataComponentPatch event, Player player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(player.registryAccess());
        buffer.writeByte(this.getId());
        buffer.writeString(player.getName().getString());
        try {
            EncoderHandler.encode(buffer, event);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer = buffer;
        IUCore.network.getClient().sendPacket((IPacket)this, buffer);
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 74;
    }

    private <T> void setData(ItemStack stack, DataComponentType<T> key, Optional<?> value) {
        stack.set(key, value.get());
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        if (!entityPlayer.getName().getString().equals(customPacketBuffer.readString())) {
            return;
        }
        ItemStack stack = entityPlayer.getItemInHand(InteractionHand.MAIN_HAND);
        try {
            DataComponentPatch tag = (DataComponentPatch)DecoderHandler.decode(customPacketBuffer);
            for (Map.Entry entry : tag.entrySet()) {
                if (entry.getKey() != DataComponentsInit.BOOKMARK) continue;
                this.setData(stack, (DataComponentType)entry.getKey(), (Optional)entry.getValue());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

