/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.network.NetworkManager;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.sound.SoundHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PacketStopSound
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketStopSound() {
    }

    public PacketStopSound(Level world, BlockPos pos) {
        List playersInRange = NetworkManager.getPlayersInRange(world, pos, new ArrayList());
        for (ServerPlayer player : playersInRange) {
            CustomPacketBuffer buffer = new CustomPacketBuffer(world.registryAccess());
            buffer.writeByte(this.getId());
            buffer.writeBlockPos(pos);
            this.buffer = buffer;
            IUCore.network.getServer().sendPacket((IPacket)this, buffer, player);
        }
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 35;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        BlockPos pos = customPacketBuffer.readBlockPos();
        SoundHandler.stopSound(pos);
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

