/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.research.api.IResearchTable;
import com.denfop.api.space.research.api.IRocketLaunchPad;
import com.denfop.api.space.rovers.Rovers;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PacketSendRoversToPlanet
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketSendRoversToPlanet() {
    }

    public PacketSendRoversToPlanet(IResearchTable base, Player player, IBody iBody) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(player.registryAccess());
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, ((BlockEntityBase)((Object)base)).getWorld());
            EncoderHandler.encode(customPacketBuffer, ((BlockEntityBase)((Object)base)).getPos());
            EncoderHandler.encode(customPacketBuffer, player.getUUID());
            customPacketBuffer.writeBoolean(iBody != null);
            if (iBody != null) {
                customPacketBuffer.writeString(iBody.getName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer = customPacketBuffer;
        IUCore.network.getClient().sendPacket((IPacket)this, customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 42;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            boolean hasBody;
            Level world = (Level)DecoderHandler.decode(customPacketBuffer);
            BlockPos pos = (BlockPos)DecoderHandler.decode(customPacketBuffer);
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.getUUID().equals(uuid) && (hasBody = customPacketBuffer.readBoolean())) {
                IRocketLaunchPad rocketLaunchPad;
                IResearchTable tileEntityResearchTableSpace;
                String body = customPacketBuffer.readString();
                IBody body1 = SpaceNet.instance.getBodyFromName(body);
                BlockEntity tile = world.getBlockEntity(pos);
                if (tile instanceof IResearchTable && (tileEntityResearchTableSpace = (IResearchTable)tile).getPlayer().equals(uuid) && (rocketLaunchPad = SpaceNet.instance.getFakeSpaceSystem().getRocketPadMap().get(uuid)) != null && rocketLaunchPad.getRover() != null) {
                    SpaceNet.instance.getResearchSystem().sendingOperation(new Rovers(rocketLaunchPad.getRover(), rocketLaunchPad.getRoverStack()), body1, tileEntityResearchTableSpace);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

