/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import java.io.IOException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PacketItemStackUpdate
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketItemStackUpdate() {
    }

    public PacketItemStackUpdate(String name, Object o, ServerPlayer playerMP) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(playerMP.registryAccess());
        buffer.writeByte(this.getId());
        buffer.writeString(name);
        try {
            EncoderHandler.encode(buffer, o);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer = buffer;
        IUCore.network.getServer().sendPacket((IPacket)this, buffer, playerMP);
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 30;
    }

    @Override
    public void readPacket(CustomPacketBuffer is, Player entityPlayer) {
        ItemStack stack;
        if (!entityPlayer.getItemInHand(InteractionHand.MAIN_HAND).isEmpty() && (stack = entityPlayer.getItemInHand(InteractionHand.MAIN_HAND)).getItem() instanceof IUpdatableItemStackEvent) {
            byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
            is.readBytes(bytes);
            if (is.readerIndex() >= is.writerIndex()) {
                Level world = entityPlayer.level();
                this.apply(stack, bytes, world);
            }
        }
    }

    private void apply(ItemStack stack, byte[] is, Level world) {
        CustomPacketBuffer buf = new CustomPacketBuffer(world.registryAccess());
        buf.writeBytes(is);
        ((IUpdatableItemStackEvent)stack.getItem()).updateField(buf.readString(), buf, stack);
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

