/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.mixin.access.ExplosionAccessor;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.Vec3;

public class PacketExplosion
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketExplosion() {
    }

    public PacketExplosion(Explosion explosion, int power, boolean flaming, boolean damage) {
        for (Player player : ((ExplosionAccessor)explosion).getLevel().players()) {
            double dz;
            double dy;
            double dx;
            double distanceSq;
            CustomPacketBuffer buffer = new CustomPacketBuffer(player.registryAccess());
            buffer.writeByte(this.getId());
            Vec3 vec = explosion.center();
            BlockPos pos = new BlockPos((int)vec.x, (int)vec.y, (int)vec.z);
            buffer.writeBlockPos(pos);
            buffer.writeInt(power);
            buffer.writeBoolean(flaming);
            buffer.writeBoolean(damage);
            if (!(player instanceof ServerPlayer) || (distanceSq = (dx = explosion.center().x - player.getX()) * dx + (dy = explosion.center().y - player.getY()) * dy + (dz = explosion.center().z - player.getZ()) * dz) > 1024.0) continue;
            this.buffer = buffer;
            IUCore.network.getServer().sendPacket((IPacket)this, buffer, (ServerPlayer)player);
        }
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 15;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        BlockPos pos = customPacketBuffer.readBlockPos();
        Explosion explosion = new Explosion(entityPlayer.level(), (Entity)entityPlayer, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)customPacketBuffer.readInt(), customPacketBuffer.readBoolean(), customPacketBuffer.readBoolean() ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.KEEP);
        explosion.explode();
        explosion.finalizeExplosion(true);
        explosion.clearToBlow();
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

