/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.io.IOException;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;

public class PacketCreateAutoSends
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketCreateAutoSends() {
    }

    public PacketCreateAutoSends(Player player, IBody iBody) {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer(player.registryAccess());
        customPacketBuffer.writeByte(this.getId());
        try {
            EncoderHandler.encode(customPacketBuffer, player.getUUID());
            customPacketBuffer.writeString(iBody.getName());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer = customPacketBuffer;
        IUCore.network.getClient().sendPacket((IPacket)this, customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 49;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        try {
            UUID uuid = (UUID)DecoderHandler.decode(customPacketBuffer);
            if (entityPlayer.getUUID().equals(uuid)) {
                String body = customPacketBuffer.readString();
                IBody body1 = SpaceNet.instance.getBodyFromName(body);
                SpaceNet.instance.getColonieNet().setAutoSends(entityPlayer.getUUID(), body1);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.CLIENT;
    }
}

