/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.network.UpdateTileEntityPacket;
import com.denfop.network.WorldData;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import com.denfop.network.packet.PacketAbstractComponent;
import com.denfop.network.packet.PacketAddBuildingToColony;
import com.denfop.network.packet.PacketAddRelocatorPoint;
import com.denfop.network.packet.PacketChangeSolarPanel;
import com.denfop.network.packet.PacketChangeSpaceOperation;
import com.denfop.network.packet.PacketColorPicker;
import com.denfop.network.packet.PacketColorPickerAllLoggIn;
import com.denfop.network.packet.PacketCreateAutoSends;
import com.denfop.network.packet.PacketCreateColony;
import com.denfop.network.packet.PacketDeleteColony;
import com.denfop.network.packet.PacketDrainFluidPipette;
import com.denfop.network.packet.PacketExplosion;
import com.denfop.network.packet.PacketFixerRecipe;
import com.denfop.network.packet.PacketItemStackEvent;
import com.denfop.network.packet.PacketItemStackUpdate;
import com.denfop.network.packet.PacketKeys;
import com.denfop.network.packet.PacketRadiation;
import com.denfop.network.packet.PacketRadiationChunk;
import com.denfop.network.packet.PacketRadiationUpdateValue;
import com.denfop.network.packet.PacketRelocatorTeleportPlayer;
import com.denfop.network.packet.PacketRemoveRelocatorPoint;
import com.denfop.network.packet.PacketReturnRoversToPlanet;
import com.denfop.network.packet.PacketSendResourceToEarth;
import com.denfop.network.packet.PacketSendRoversToPlanet;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketStopSoundPlayer;
import com.denfop.network.packet.PacketSuccessUpdateColony;
import com.denfop.network.packet.PacketSynhronyzationRelocator;
import com.denfop.network.packet.PacketUpdateBody;
import com.denfop.network.packet.PacketUpdateBookMarks;
import com.denfop.network.packet.PacketUpdateCompleteQuest;
import com.denfop.network.packet.PacketUpdateFakeBody;
import com.denfop.network.packet.PacketUpdateFieldContainerTile;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.network.packet.PacketUpdateInformationAboutQuestsPlayer;
import com.denfop.network.packet.PacketUpdateInventory;
import com.denfop.network.packet.PacketUpdateOvertimeTile;
import com.denfop.network.packet.PacketUpdateRadiation;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.network.packet.PacketUpdateRecipe;
import com.denfop.network.packet.PacketUpdateRelocator;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.network.packet.PacketUpdateSkipQuest;
import com.denfop.network.packet.PacketUpdateTile;
import com.denfop.network.packet.PacketUpdateVeinData;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class NetworkManager {
    public static Map<Byte, IPacket> packetMap = new HashMap<Byte, IPacket>();
    public static Map<Byte, CustomPacketPayload.Type<IPacket>> packetTypeMap = new HashMap<Byte, CustomPacketPayload.Type<IPacket>>();
    public static boolean reg = false;
    public static StreamCodec<RegistryFriendlyByteBuf, IPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, IPacket>(){

        public IPacket decode(RegistryFriendlyByteBuf p_320167_) {
            IPacket packet;
            CustomPacketBuffer packetBuffer = new CustomPacketBuffer(p_320167_);
            try {
                packet = (IPacket)packetMap.get(packetBuffer.readByte()).getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            byte[] bytes = new byte[p_320167_.writerIndex() - p_320167_.readerIndex()];
            p_320167_.readBytes(bytes);
            packetBuffer = new CustomPacketBuffer(bytes, p_320167_.registryAccess());
            packet.setPacketBuffer(packetBuffer);
            return packet;
        }

        public void encode(RegistryFriendlyByteBuf p_320240_, IPacket p_341316_) {
            CustomPacketBuffer customPacketBuffer = p_341316_.getPacketBuffer();
            customPacketBuffer.flip();
            p_320240_.writeBytes((ByteBuf)customPacketBuffer);
            customPacketBuffer.flip();
            p_341316_.setPacketBuffer(customPacketBuffer);
        }
    };

    public NetworkManager() {
        IUCore.context.addListener(this::register);
    }

    public static <T extends Collection<ServerPlayer>> T getPlayersInRange(Level world, BlockPos pos, T result) {
        if (!(world instanceof ServerLevel)) {
            return result;
        }
        List list = ((ServerLevel)world).getChunkSource().chunkMap.getPlayers(new ChunkPos(pos), false);
        result.addAll(list);
        return result;
    }

    @SubscribeEvent
    public void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar handler = event.registrar("industrialupgrade");
        this.registerPacket(new PacketKeys());
        this.registerPacket(new PacketAbstractComponent());
        this.registerPacket(new PacketColorPickerAllLoggIn());
        this.registerPacket(new PacketRadiation());
        this.registerPacket(new PacketUpdateServerTile());
        this.registerPacket(new PacketUpdateTile());
        this.registerPacket(new PacketRadiationChunk());
        this.registerPacket(new PacketRadiationUpdateValue());
        this.registerPacket(new PacketUpdateFieldContainerTile());
        this.registerPacket(new PacketColorPicker());
        this.registerPacket(new PacketUpdateFieldTile());
        this.registerPacket(new PacketExplosion());
        this.registerPacket(new PacketChangeSolarPanel());
        this.registerPacket(new PacketSoundPlayer());
        this.registerPacket(new PacketUpdateOvertimeTile());
        this.registerPacket(new PacketItemStackUpdate());
        this.registerPacket(new PacketItemStackEvent());
        this.registerPacket(new PacketStopSound());
        this.registerPacket(new PacketUpdateInventory());
        this.registerPacket(new PacketUpdateRadiationValue());
        this.registerPacket(new PacketUpdateRadiation());
        this.registerPacket(new PacketStopSoundPlayer());
        this.registerPacket(new PacketAddRelocatorPoint());
        this.registerPacket(new PacketRemoveRelocatorPoint());
        this.registerPacket(new PacketRelocatorTeleportPlayer());
        this.registerPacket(new PacketUpdateBody());
        this.registerPacket(new PacketUpdateFakeBody());
        this.registerPacket(new PacketSendRoversToPlanet());
        this.registerPacket(new PacketReturnRoversToPlanet());
        this.registerPacket(new PacketChangeSpaceOperation());
        this.registerPacket(new PacketCreateColony());
        this.registerPacket(new PacketSendResourceToEarth());
        this.registerPacket(new PacketAddBuildingToColony());
        this.registerPacket(new PacketSuccessUpdateColony());
        this.registerPacket(new PacketCreateAutoSends());
        this.registerPacket(new PacketDeleteColony());
        this.registerPacket(new PacketUpdateCompleteQuest());
        this.registerPacket(new PacketUpdateInformationAboutQuestsPlayer());
        this.registerPacket(new PacketSynhronyzationRelocator());
        this.registerPacket(new PacketUpdateRelocator());
        this.registerPacket(new PacketDrainFluidPipette());
        this.registerPacket(new PacketUpdateSkipQuest());
        this.registerPacket(new PacketUpdateBookMarks());
        this.registerPacket(new PacketUpdateVeinData());
        this.registerPacket(new PacketUpdateRecipe());
        this.registerPacket(new PacketFixerRecipe());
        if (!reg) {
            reg = true;
            for (IPacket packet : packetMap.values()) {
                CustomPacketPayload.Type TYPE;
                if (packet.getPacketType() == EnumTypePacket.CLIENT) {
                    TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"industrialupgrade", (String)("packet_" + packet.getId())));
                    packetTypeMap.put(packet.getId(), (CustomPacketPayload.Type<IPacket>)TYPE);
                    handler.playToServer(TYPE, STREAM_CODEC, (payload, context) -> IUCore.network.getServer().onPacketData(payload.getPacketBuffer(), context));
                    continue;
                }
                TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"industrialupgrade", (String)("packet_" + packet.getId())));
                packetTypeMap.put(packet.getId(), (CustomPacketPayload.Type<IPacket>)TYPE);
                handler.playToClient(TYPE, STREAM_CODEC, (payload, context) -> IUCore.network.getServer().onPacketData(payload.getPacketBuffer(), context));
            }
        }
    }

    public IPacket makePacket(IPacket packet, CustomPacketBuffer buffer) {
        CustomPacketBuffer buf = new CustomPacketBuffer(Unpooled.buffer(), packet.getPacketBuffer().registryAccess());
        buf.writeByte(packet.getId());
        buf.writeBoolean(this.isClient());
        buf.writeBytes((ByteBuf)buffer);
        try {
            packet = (IPacket)packet.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        packet.setPacketBuffer(buf);
        return packet;
    }

    public IPacket makePacket(IPacket packet) {
        CustomPacketBuffer buf = new CustomPacketBuffer(Unpooled.buffer(), packet.getPacketBuffer().registryAccess());
        buf.writeByte(packet.getId());
        buf.writeBoolean(this.isClient());
        buf.writeBytes((ByteBuf)packet.getPacketBuffer());
        try {
            packet = (IPacket)packet.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        packet.setPacketBuffer(buf);
        return packet;
    }

    public void sendPacket(IPacket packet, CustomPacketBuffer buffer) {
        if (!this.isClient()) {
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)this.makePacket(packet, buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            IUCore.network.getClient().sendPacket(packet, null, buffer);
        }
    }

    public void sendPacket(IPacket packet, Player player, CustomPacketBuffer buffer) {
        if (!this.isClient()) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)this.makePacket(packet, buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            IUCore.network.getClient().sendPacket(packet, player, buffer);
        }
    }

    public void registerPacket(IPacket packet) {
        if (!packetMap.containsKey(packet.getId())) {
            packetMap.put(packet.getId(), packet);
        }
    }

    protected boolean isClient() {
        return false;
    }

    public void onPacketData(CustomPacketBuffer is, IPayloadContext ctx) {
        try {
            boolean isClient = is.readBoolean();
            if (!isClient) {
                byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
                is.readBytes(bytes);
                ctx.enqueueWork(() -> {
                    CustomPacketBuffer is1 = new CustomPacketBuffer(bytes, is.registryAccess());
                    if (is1.writerIndex() > is1.readerIndex()) {
                        byte type = is1.readByte();
                        IUCore.network.getClient().onPacketData(is1, type);
                    }
                });
            } else {
                byte[] bytes = new byte[is.writerIndex() - is.readerIndex()];
                is.readBytes(bytes);
                ctx.enqueueWork(() -> {
                    CustomPacketBuffer is1 = new CustomPacketBuffer(bytes, is.registryAccess());
                    if (is1.writerIndex() > is1.readerIndex()) {
                        try {
                            byte type = is1.readByte();
                            IPacket packet = packetMap.get(type);
                            if (packet != null && packet.getPacketType() == EnumTypePacket.CLIENT) {
                                packet.readPacket(is1, ctx.player());
                            }
                        }
                        catch (Exception e) {
                            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u0430: " + e.getMessage());
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            System.err.println("\u041e\u0448\u0438\u0431\u043a\u0430 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043f\u0430\u043a\u0435\u0442\u0430: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void onPacketData(CustomPacketBuffer is, byte type) {
    }

    public final void sendPacket(IPacket buffer, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.makePacket(buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public final void sendPacket(IPacket buffer, CustomPacketBuffer is, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.makePacket(buffer, is), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendPacket(IPacket buffer) {
        if (!this.isClient()) {
            PlayerList players = ServerLifecycleHooks.getCurrentServer().getPlayerList();
            for (ServerPlayer player : players.getPlayers()) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)this.makePacket(buffer), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        } else {
            IUCore.network.getClient().sendPacket(buffer);
        }
    }

    public void onTickEnd(WorldData worldData) {
        try {
            UpdateTileEntityPacket.send(worldData);
        }
        catch (IOException var3) {
            throw new RuntimeException(var3);
        }
    }

    public void addTileContainerToUpdate(BlockEntityBase te, ServerPlayer player, CustomPacketBuffer packetBuffer) {
        Map<ServerPlayer, CustomPacketBuffer> map;
        if (te == null) {
            return;
        }
        WorldData worldData = WorldData.get(te.getLevel());
        if (te.isRemoved()) {
            return;
        }
        if (worldData.mapUpdateContainer.containsKey((Object)te)) {
            map = worldData.mapUpdateContainer.computeIfAbsent(te, k -> new HashMap());
        } else {
            map = new HashMap();
            worldData.mapUpdateContainer.put(te, map);
        }
        map.put(player, packetBuffer);
    }

    public void addTileToUpdate(BlockEntityBase te) {
        if (te.hasLevel()) {
            WorldData worldData = WorldData.get(te.getLevel());
            worldData.listUpdateTile.add(te);
        }
    }

    public void addTileToOvertimeUpdate(BlockEntityBase te) {
        WorldData worldData = WorldData.get(te.getLevel());
        if (!worldData.mapUpdateOvertimeField.containsKey(te.getBlockPos())) {
            worldData.mapUpdateOvertimeField.put(te.getBlockPos(), te);
        }
    }

    public void removeTileToOvertimeUpdate(BlockEntityBase te) {
        WorldData worldData = WorldData.get(te.getLevel());
        worldData.mapUpdateOvertimeField.remove(te.getBlockPos());
    }

    public void addTileFieldToUpdate(BlockEntityBase te, CustomPacketBuffer packet) {
        WorldData worldData = WorldData.get(te.getLevel());
        if (worldData.mapUpdateField.containsKey((Object)te)) {
            worldData.mapUpdateField.get((Object)te).add(packet);
        } else {
            worldData.mapUpdateField.put(te, new LinkedList<CustomPacketBuffer>(Collections.singletonList(packet)));
        }
    }
}

