/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network;

import com.denfop.IUCore;
import com.denfop.api.pollution.radiation.Radiation;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeInfo;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.vein.common.VeinBase;
import com.denfop.blockentity.base.DataOre;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EncodedType;
import com.denfop.utils.ModUtils;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class DecoderHandler {
    private static final Map<Class<?>, EncodedType> classToTypeCache = Collections.synchronizedMap(new IdentityHashMap());

    public static Object decode(CustomPacketBuffer is) throws IOException {
        try {
            return DecoderHandler.decode(is, DecoderHandler.typeFromId(is.readUnsignedByte()));
        }
        catch (IllegalArgumentException var3) {
            return null;
        }
    }

    public static <T> T decode(CustomPacketBuffer is, Class<T> clazz) throws IOException {
        EncodedType type = DecoderHandler.typeFromClass(clazz);
        if (type.threadSafe) {
            return (T)DecoderHandler.decode(is, type);
        }
        throw new IllegalArgumentException("requesting decode for non thread safe type");
    }

    public static Object decodeDeferred(CustomPacketBuffer is, Class<?> clazz) throws IOException {
        EncodedType type = DecoderHandler.typeFromClass(clazz);
        return DecoderHandler.decode(is, type);
    }

    private static EncodedType typeFromId(int id) {
        if (id >= 0 && id < EncodedType.types.length) {
            return EncodedType.types[id];
        }
        throw new IllegalArgumentException("invalid type id: " + id);
    }

    private static Class<?> box(Class<?> clazz) {
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        return clazz == Character.TYPE ? Character.class : clazz;
    }

    private static Class<?> unbox(Class<?> clazz) {
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        return clazz == Character.class ? Character.TYPE : clazz;
    }

    private static EncodedType typeFromClass(Class<?> cls) {
        EncodedType[] var3;
        EncodedType ret;
        if (cls == null) {
            return EncodedType.Null;
        }
        if (cls.isArray()) {
            return EncodedType.Array;
        }
        if (cls.isPrimitive()) {
            cls = DecoderHandler.box(cls);
        }
        if ((ret = EncodedType.classToTypeMap.get(cls)) != null) {
            return ret;
        }
        ret = classToTypeCache.get(cls);
        if (ret != null) {
            return ret;
        }
        for (EncodedType type : var3 = EncodedType.types) {
            if (type.cls == null || !type.cls.isAssignableFrom(cls)) continue;
            classToTypeCache.put(cls, type);
            return type;
        }
        throw new IllegalStateException("unmatched " + String.valueOf(cls));
    }

    private static Class<?> getClass(String type) {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException var2) {
            throw new RuntimeException("Missing type from the class path expected by network: " + type, var2);
        }
    }

    public static Block getBlock(ResourceLocation loc) {
        Block ret = (Block)BuiltInRegistries.BLOCK.get(loc);
        if (ret != Blocks.AIR) {
            return ret;
        }
        return loc.getNamespace().equals("minecraft") && loc.getPath().equals("air") ? ret : null;
    }

    public static Object decode(CustomPacketBuffer is, EncodedType type) throws IOException {
        switch (type) {
            case Array: {
                Class<?> component;
                EncodedType componentType = DecoderHandler.typeFromId(is.readUnsignedByte());
                boolean primitive = is.readBoolean();
                boolean isEnum = componentType == EncodedType.Enum;
                Class<?> clazz = component = primitive ? DecoderHandler.unbox(componentType.cls) : componentType.cls;
                if (component == null || isEnum) {
                    assert (isEnum);
                    component = DecoderHandler.getClass(is.readString());
                }
                Class<?> componentClass = component;
                int len = is.readVarInt();
                boolean anyTypeMismatch = is.readBoolean();
                boolean needsResolving = !componentType.threadSafe;
                Object array = new Object[len];
                array = !needsResolving ? Array.newInstance(component, len) : new Object[len];
                if (!anyTypeMismatch) {
                    if (isEnum) {
                        ?[] constants = component.getEnumConstants();
                        assert (constants != null);
                        for (int k = 0; k < len; ++k) {
                            Array.set(array, k, constants[(Integer)DecoderHandler.decode(is, componentType)]);
                        }
                    } else {
                        for (i = 0; i < len; ++i) {
                            Array.set(array, i, DecoderHandler.decode(is, componentType));
                        }
                    }
                } else {
                    for (i = 0; i < len; ++i) {
                        EncodedType cType = DecoderHandler.typeFromId(is.readUnsignedByte());
                        if (!cType.threadSafe && !needsResolving) {
                            needsResolving = true;
                            if (componentClass != Object.class) {
                                Object[] newArray = new Object[len];
                                System.arraycopy(array, 0, newArray, 0, i);
                                array = newArray;
                            }
                        }
                        Array.set(array, i, DecoderHandler.decode(is, cType));
                    }
                }
                if (!needsResolving) {
                    return array;
                }
                Object finalArray = array;
                Object ret_array = Array.newInstance(componentClass, len);
                for (int i1 = 0; i1 < len; ++i1) {
                    Array.set(ret_array, i1, DecoderHandler.getValue(Array.get(finalArray, i1)));
                }
                return ret_array;
            }
            case Block: {
                return DecoderHandler.getBlock((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case network_object: {
                return is;
            }
            case BlockPos: {
                return new BlockPos(is.readInt(), is.readInt(), is.readInt());
            }
            case Boolean: {
                return is.readBoolean();
            }
            case Byte: {
                return is.readByte();
            }
            case Character: {
                return Character.valueOf(is.readChar());
            }
            case ChunkPos: {
                return new ChunkPos(is.readInt(), is.readInt());
            }
            case Collection: {
                Object ret = DecoderHandler.decode(is, EncodedType.Array);
                return Arrays.asList((Object[])ret);
            }
            case Component: {
                return is;
            }
            case Double: {
                return is.readDouble();
            }
            case Enchantment: {
                return is.registryAccess().registryOrThrow(Registries.ENCHANTMENT).get((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case Enum: {
                return is.readVarInt();
            }
            case Float: {
                return Float.valueOf(is.readFloat());
            }
            case Fluid: {
                return BuiltInRegistries.FLUID.get((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case FluidStack: {
                ResourceLocation resourceLocation1 = (ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation);
                DataComponentPatch componentPatch = null;
                int amount = is.readInt();
                if (is.readBoolean()) {
                    componentPatch = (DataComponentPatch)DecoderHandler.decode(is);
                }
                if (componentPatch != null) {
                    FluidStack ret2 = new FluidStack((Holder)is.registryAccess().registryOrThrow(Registries.FLUID).getHolder(resourceLocation1).get(), amount, componentPatch);
                    return ret2;
                }
                FluidStack ret2 = new FluidStack((Holder)is.registryAccess().registryOrThrow(Registries.FLUID).getHolder(resourceLocation1).get(), amount);
                return ret2;
            }
            case FluidTank: {
                FluidStack fluidStack = (FluidStack)DecoderHandler.decode(is);
                FluidTank fluidTank = new FluidTank(is.readInt());
                fluidTank.setFluid(fluidStack);
                return fluidTank;
            }
            case recipeOutput: {
                List itemStackList = (List)DecoderHandler.decode(is);
                CompoundTag compoundTag = null;
                boolean hasTag = (Boolean)DecoderHandler.decode(is);
                if (hasTag) {
                    compoundTag = (CompoundTag)DecoderHandler.decode(is);
                }
                return new RecipeOutput(compoundTag, itemStackList);
            }
            case inputStack: {
                CompoundTag compoundTag = (CompoundTag)DecoderHandler.decode(is);
                return Input.readNBT(compoundTag, is.registryAccess());
            }
            case inputFluidStack: {
                CompoundTag compoundTag = (CompoundTag)DecoderHandler.decode(is);
                return InputFluid.readNBT(compoundTag, is.registryAccess());
            }
            case BaseRecipe: {
                return BaseMachineRecipe.readNBT((CompoundTag)DecoderHandler.decode(is), is.registryAccess());
            }
            case BaseFluidRecipe: {
                return BaseFluidMachineRecipe.readNBT((CompoundTag)DecoderHandler.decode(is), is.registryAccess());
            }
            case GameProfile: {
                return new GameProfile((UUID)DecoderHandler.decode(is), is.readString());
            }
            case Integer: {
                return is.readInt();
            }
            case InvSlot: {
                ItemStack[] contents = (ItemStack[])DecoderHandler.decode(is, EncodedType.Array);
                Inventory ret3 = new Inventory(contents.length);
                for (int i = 0; i < contents.length; ++i) {
                    ret3.set(i, contents[i]);
                }
                return ret3;
            }
            case Item: {
                return BuiltInRegistries.ITEM.get((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case ItemStack: {
                byte size = is.readByte();
                if (size == 0) {
                    return ModUtils.emptyStack;
                }
                ResourceLocation resourceLocation = (ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation);
                DataComponentPatch componentPatch1 = null;
                if (is.readBoolean()) {
                    componentPatch1 = (DataComponentPatch)DecoderHandler.decode(is);
                }
                Holder.Reference holder = (Holder.Reference)is.registryAccess().registryOrThrow(Registries.ITEM).getHolder(resourceLocation).get();
                if (componentPatch1 == null) {
                    return new ItemStack((Holder)holder, (int)size);
                }
                ItemStack ret1 = new ItemStack((Holder)holder, (int)size, componentPatch1);
                return ret1;
            }
            case DataComponentPatch: {
                return DataComponentPatch.STREAM_CODEC.decode((Object)is);
            }
            case Long: {
                return is.readLong();
            }
            case NBTTagCompound: {
                return NbtIo.read((DataInput)new ByteBufInputStream((ByteBuf)is), (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            case Null: {
                return null;
            }
            case Object: {
                return new Object();
            }
            case Potion: {
                return BuiltInRegistries.POTION.get((ResourceLocation)DecoderHandler.decode(is, EncodedType.ResourceLocation));
            }
            case ResourceLocation: {
                return ResourceLocation.tryBuild((String)is.readString(), (String)is.readString());
            }
            case Short: {
                return is.readShort();
            }
            case String: {
                return is.readString();
            }
            case TileEntity: {
                Level deferredWorld = (Level)DecoderHandler.decode(is, EncodedType.World);
                BlockPos pos = (BlockPos)DecoderHandler.decode(is, EncodedType.BlockPos);
                return deferredWorld.getChunkAt(pos).getBlockEntity(pos);
            }
            case UUID: {
                return new UUID(is.readLong(), is.readLong());
            }
            case Vec3: {
                return new Vec3(is.readDouble(), is.readDouble(), is.readDouble());
            }
            case DataOre: {
                return new DataOre(is);
            }
            case Vein: {
                return new VeinBase(is);
            }
            case RecipeInfo: {
                return new RecipeInfo(is);
            }
            case Radiation: {
                return new Radiation(is);
            }
            case World: {
                return IUCore.proxy.getWorld((ResourceKey<Level>)is.readResourceKey(Registries.DIMENSION));
            }
        }
        throw new IllegalArgumentException("unhandled type: " + String.valueOf((Object)type));
    }

    public static <T> T getValue(Object decoded) {
        return (T)decoded;
    }
}

