/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.IUCore;
import com.denfop.api.item.armor.HazmatLike;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.ItemMain;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.potion.IUPotion;
import java.util.Locale;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class RadiationPellets<T extends Enum<T>>
extends ItemMain<T>
implements IRadioactiveItemType {
    public RadiationPellets(T element) {
        super(new Item.Properties(), element);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotIndex, boolean isCurrentItem) {
        LivingEntity entityLiving;
        if (entity instanceof LivingEntity && !HazmatLike.hasCompleteHazmat(entityLiving = (LivingEntity)entity)) {
            IUPotion.radiation.applyEffect(entityLiving, this.getRadiationDuration());
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ReactorsTab;
    }

    @Override
    public int getRadiationDuration() {
        return 200;
    }

    @Override
    public int getRadiationAmplifier() {
        return 100;
    }

    public static enum Types implements ISubEnum
    {
        americium_pellet(0),
        neptunium_pellet(1),
        curium_pellet(2),
        california_pellet(3),
        rad_toriy_pellet(4),
        mendelevium_gem_pellet(5),
        berkelium_gem_pellet(6),
        einsteinium_gem_pellet(7),
        uran233_gem_pellet(8),
        proton_pellet(9),
        fermium_pellet(10),
        nobelium_pellet(11),
        lawrencium_pellet(12);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "pellets";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

