/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.IUCore;
import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.items.reactors.ItemDamage;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ItemReactorVent
extends ItemDamage
implements IReactorItem,
IItemTab {
    private final int level;
    private final int heat_to_damage;
    private final double heat_damage;
    private final int autoRepair;

    public ItemReactorVent(int maxDamage, int level, int heat_to_damage, double heat_damage, int autoRepair) {
        super(new Item.Properties().stacksTo(1), maxDamage);
        this.level = level;
        this.heat_to_damage = heat_to_damage;
        this.heat_damage = heat_damage;
        this.autoRepair = autoRepair;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ReactorsTab;
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            ResourceLocation res = BuiltInRegistries.ITEM.getKey((Object)this);
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)res));
            String targetString = res.getNamespace() + ".";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = res.getNamespace().startsWith("industrialupgrade") ? "iu." + pathBuilder.toString().split("\\.")[2] : res.getNamespace() + "." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public void appendHoverText(ItemStack p_41421_, @Nullable Item.TooltipContext p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)(Localization.translate("iu.reactoritem.durability") + " " + (this.getMaxCustomDamage(p_41421_) - this.getCustomDamage(p_41421_)) + "/" + this.getMaxCustomDamage(p_41421_))));
        p_41423_.add((Component)Component.literal((String)Localization.translate("reactor.vent", this.autoRepair)));
        p_41423_.add((Component)Component.literal((String)Localization.translate("reactor.vent1", 1, this.heat_to_damage)));
        p_41423_.add((Component)Component.literal((String)Localization.translate("reactor.vent2", (int)Math.ceil((1.0 - this.heat_damage) * 100.0), "%")));
        p_41423_.add((Component)Component.literal((String)(Localization.translate("reactor.component_level") + this.level)));
        p_41423_.add((Component)Component.literal((String)Localization.translate("reactor.component_level1")));
    }

    @Override
    public EnumTypeComponent getType() {
        return EnumTypeComponent.HEAT_SINK;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getAutoRepair(IAdvReactor reactor) {
        return (int)((double)this.autoRepair * reactor.getModuleComponentVent());
    }

    @Override
    public int getRepairOther(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public boolean needClear(ItemStack stack) {
        return this.getMaxCustomDamage(stack) - this.getCustomDamage(stack) == 0;
    }

    @Override
    public int getDamageCFromHeat(int heat, IAdvReactor reactor) {
        return this.heat_to_damage;
    }

    @Override
    public int getHeat(IAdvReactor reactor) {
        return 0;
    }

    @Override
    public double getHeatRemovePercent(IAdvReactor reactor) {
        return this.heat_damage * reactor.getModuleVent();
    }

    @Override
    public void damageItem(ItemStack stack, int damage) {
        this.applyCustomDamage(stack, damage, null);
    }

    @Override
    public boolean updatableItem() {
        return true;
    }

    @Override
    public boolean caneExtractHeat() {
        return true;
    }

    @Override
    public double getEnergyProduction(IAdvReactor reactor) {
        return 0.0;
    }
}

