/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.api.item.DamageItem;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class ItemDamage
extends Item
implements DamageItem {
    private final int maxDamageItem;
    protected String nameItem;

    public ItemDamage(Item.Properties properties, int maxDamage) {
        super(maxDamage == 0 ? properties.stacksTo(1) : properties.stacksTo(1).durability(maxDamage));
        this.maxDamageItem = maxDamage;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxCustomDamage(stack);
    }

    public int getDamage(ItemStack stack) {
        if (!stack.has(DataComponents.DAMAGE)) {
            stack.set(DataComponents.DAMAGE, (Object)0);
        }
        return (Integer)stack.get(DataComponents.DAMAGE);
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return true;
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        return Math.round(13.0f - (float)((double)this.getCustomDamage(stack) * 13.0 / (double)this.getMaxCustomDamage(stack)));
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)((float)(Math.max(0.0, 1.0 - (double)this.getCustomDamage(stack) / (double)this.getMaxCustomDamage(stack)) / 3.0)), (float)1.0f, (float)1.0f);
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean isDamaged(@Nonnull ItemStack stack) {
        return this.getCustomDamage(stack) > 0;
    }

    @Override
    public int getCustomDamage(ItemStack stack) {
        if (!stack.has(DataComponents.DAMAGE)) {
            return 0;
        }
        assert (stack.get(DataComponents.DAMAGE) != null);
        return (Integer)stack.get(DataComponents.DAMAGE);
    }

    @Override
    public int getMaxCustomDamage(ItemStack stack) {
        return this.maxDamageItem;
    }

    public void setDamage(@Nonnull ItemStack stack, int damage) {
    }

    @Override
    public void setCustomDamage(ItemStack stack, int damage) {
        if (damage > this.maxDamageItem) {
            damage = this.maxDamageItem;
        }
        stack.set(DataComponents.DAMAGE, (Object)damage);
    }

    @Override
    public boolean applyCustomDamage(ItemStack stack, int damage, LivingEntity src) {
        int damage1 = this.getCustomDamage(stack) + damage;
        if (damage1 <= 0) {
            damage1 = 0;
        }
        this.setCustomDamage(stack, damage1);
        return true;
    }
}

