/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.modules;

import com.denfop.IUCore;
import com.denfop.api.reactors.IReactorModule;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.ItemMain;
import com.denfop.utils.Localization;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ItemReactorModules<T extends Enum<T>>
extends ItemMain<T>
implements IReactorModule {
    public ItemReactorModules(T element) {
        super(new Item.Properties(), element);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ModuleTab;
    }

    @Override
    public double getStableHeat(ItemStack stack) {
        Types craftingTypes = (Types)this.getElement();
        return craftingTypes.getStableHeat();
    }

    @Override
    public double getRadiation(ItemStack stack) {
        Types craftingTypes = (Types)this.getElement();
        return craftingTypes.getRadiation();
    }

    @Override
    public double getGeneration(ItemStack stack) {
        Types craftingTypes = (Types)this.getElement();
        return craftingTypes.getGeneration();
    }

    @Override
    public double getComponentVent(ItemStack stack) {
        Types craftingTypes = (Types)this.getElement();
        return craftingTypes.getComponentVent();
    }

    @Override
    public double getVent(ItemStack stack) {
        Types craftingTypes = (Types)this.getElement();
        return craftingTypes.getVent();
    }

    @Override
    public double getExchanger(ItemStack stack) {
        Types craftingTypes = (Types)this.getElement();
        return craftingTypes.getExchanger();
    }

    @Override
    public double getCapacitor(ItemStack stack) {
        Types craftingTypes = (Types)this.getElement();
        return craftingTypes.getCapacitor();
    }

    @Override
    public void appendHoverText(ItemStack p_41421_, @Nullable Item.TooltipContext p_41422_, List<Component> info, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_41422_, info, p_41424_);
        Types craftingTypes = (Types)this.getElement();
        double generation = craftingTypes.generation - 1.0;
        double radiation = craftingTypes.radiation - 1.0;
        double stableHeat = craftingTypes.stableHeat - 1.0;
        double capacitor = craftingTypes.capacitor - 1.0;
        double exchanger = craftingTypes.exchanger - 1.0;
        double vent = craftingTypes.vent - 1.0;
        double componentVent = craftingTypes.componentVent - 1.0;
        if (generation > 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.generation_plus") + ((int)(craftingTypes.generation * 100.0) - 100) + "%")));
        } else if (generation < 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.generation_minus") + (100 - (int)(craftingTypes.generation * 100.0)) + "%")));
        }
        if (radiation > 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.radiation_plus") + ((int)(craftingTypes.radiation * 100.0) - 100) + "%")));
        } else if (radiation < 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.radiation_minus") + (100 - (int)(craftingTypes.radiation * 100.0)) + "%")));
        }
        if (vent > 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.vent_plus") + ((int)(craftingTypes.vent * 100.0) - 100) + "%")));
        } else if (vent < 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.vent_minus") + (100 - (int)(craftingTypes.vent * 100.0)) + "%")));
        }
        if (stableHeat > 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.stableheat_plus") + ((int)(craftingTypes.stableHeat * 100.0) - 100) + "%")));
        } else if (stableHeat < 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.stableheat_minus") + (100 - (int)(craftingTypes.stableHeat * 100.0)) + "%")));
        }
        if (capacitor > 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.capacitor_plus") + ((int)(craftingTypes.capacitor * 100.0) - 100) + "%")));
        } else if (capacitor < 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.capacitor_minus") + (100 - (int)(craftingTypes.capacitor * 100.0)) + "%")));
        }
        if (componentVent > 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.componentvent_plus") + ((int)(craftingTypes.componentVent * 100.0) - 100) + "%")));
        } else if (componentVent < 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.componentvent_minus") + (100 - (int)(craftingTypes.componentVent * 100.0)) + "%")));
        }
        if (exchanger > 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.exchanger_plus") + ((int)(craftingTypes.exchanger * 100.0) - 100) + "%")));
        } else if (exchanger < 0.0) {
            info.add((Component)Component.literal((String)(Localization.translate("reactor.exchanger_minus") + (100 - (int)(craftingTypes.exchanger * 100.0)) + "%")));
        }
    }

    public static enum Types implements ISubEnum
    {
        generation0(0.98, 1.0, 1.05, 1.0, 1.0, 1.0, 1.0),
        generation1(0.95, 1.0, 1.1, 1.0, 1.0, 1.0, 1.0),
        generation2(0.92, 1.0, 1.15, 1.0, 1.0, 1.0, 1.0),
        generation3(0.9, 1.0, 1.2, 1.0, 1.0, 1.0, 1.0),
        radiation0(1.02, 1.25, 1.0, 1.0, 1.0, 1.0, 1.0),
        radiation1(1.05, 1.5, 1.0, 1.0, 1.0, 1.0, 1.0),
        radiation2(1.08, 2.0, 1.0, 1.0, 1.0, 1.0, 1.0),
        radiation3(1.1, 4.0, 1.0, 1.0, 1.0, 1.0, 1.0),
        stableheat0(1.05, 1.25, 0.98, 1.0, 1.0, 1.0, 1.0),
        stableheat1(1.1, 2.5, 0.95, 1.0, 1.0, 1.0, 1.0),
        stableheat2(1.15, 3.0, 0.9, 1.0, 1.0, 1.0, 1.0),
        stableheat3(1.2, 4.0, 0.85, 1.0, 1.0, 1.0, 1.0),
        vent0(1.0, 1.0, 1.0, 1.0, 1.05, 0.95, 1.0),
        vent1(1.0, 1.0, 1.0, 1.0, 1.1, 0.9, 1.0),
        vent2(1.0, 1.0, 1.0, 0.8, 1.15, 0.9, 1.0),
        vent3(1.0, 1.0, 1.0, 0.75, 1.2, 0.85, 1.0),
        componentvent0(1.0, 1.0, 1.0, 1.25, 0.95, 0.95, 1.0),
        componentvent1(1.0, 1.0, 1.0, 1.5, 0.925, 0.925, 1.0),
        componentvent2(1.0, 1.0, 1.0, 1.75, 0.9, 0.9, 1.0),
        componentvent3(1.0, 1.0, 1.0, 2.0, 0.88, 0.88, 1.0),
        exchanger0(0.98, 1.0, 1.0, 1.1, 0.9, 1.05, 1.0),
        exchanger1(0.95, 1.0, 1.0, 1.25, 0.875, 1.1, 1.0),
        exchanger2(0.925, 1.0, 1.0, 1.25, 0.85, 1.2, 1.0),
        exchanger3(0.9, 1.0, 1.0, 1.25, 0.825, 1.3, 1.0),
        capacitor0(1.0, 1.0, 0.975, 1.1, 1.0, 1.0, 1.25),
        capacitor1(1.0, 1.0, 0.95, 1.2, 1.0, 1.0, 1.5),
        capacitor2(1.0, 1.0, 0.925, 1.4, 1.0, 1.0, 2.0),
        capacitor3(1.0, 1.0, 0.9, 1.8, 1.0, 1.0, 2.5);

        private final String name = this.name().toLowerCase(Locale.US);
        private double stableHeat;
        private double radiation;
        private double generation;
        private double componentVent;
        private double vent;
        private double exchanger;
        private double capacitor;

        private Types(double stableHeat, double radiation, double generation, double componentVent, double vent, double exchanger, double capacitor) {
            this.stableHeat = stableHeat;
            this.radiation = radiation;
            this.generation = generation;
            this.vent = vent;
            this.componentVent = componentVent;
            this.exchanger = exchanger;
            this.capacitor = capacitor;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        public double getCapacitor() {
            return this.capacitor;
        }

        public double getComponentVent() {
            return this.componentVent;
        }

        public double getExchanger() {
            return this.exchanger;
        }

        public double getGeneration() {
            return this.generation;
        }

        public double getRadiation() {
            return this.radiation;
        }

        public double getStableHeat() {
            return this.stableHeat;
        }

        public double getVent() {
            return this.vent;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "reactormodules";
        }

        @Override
        public int getId() {
            return this.ordinal();
        }
    }
}

