/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy.instruments;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.api.item.upgrade.LevelInstruments;
import com.denfop.api.item.upgrade.UpgradeItemInform;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.UpgradeWithBlackList;
import com.denfop.api.item.upgrade.event.EventItemBlackListLoad;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.UpgradeItem;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.IProperties;
import com.denfop.items.energy.ItemStackUpgradeItem;
import com.denfop.items.energy.instruments.EnumOperations;
import com.denfop.items.energy.instruments.EnumTypeInstruments;
import com.denfop.items.energy.instruments.EnumVarietyInstruments;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.proxy.CommonProxy;
import com.denfop.sound.EnumSound;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.utils.RetraceDiggingUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class ItemEnergyInstruments
extends Item
implements EnergyItem,
IItemStackInventory,
UpgradeWithBlackList,
LevelInstruments,
IProperties,
IItemTab {
    private final String name;
    private final int transferLimit;
    private final int maxCharge;
    private final int tier;
    private final int normalPower;
    private final int bigHolePower;
    private final int energyPerOperation;
    private final int energyBigHolePowerOperation;
    private final int ultraLowPower1;
    private final int ultraLowPower;
    private final Set<BlockState> mineableBlocks;
    private final int energyPerbigHolePowerOperation;
    private final int energyPerultraLowPowerOperation;
    private final List<EnumOperations> operations;
    private final List<TagKey<Block>> item_tools;
    private final String name_type;
    private final float fuel_balance = 10.0f;
    private final EnumTypeInstruments type;
    Set<String> toolType;
    private int efficiency;
    private String nameItem;

    public ItemEnergyInstruments(EnumTypeInstruments type, EnumVarietyInstruments variety, String name) {
        super(new Item.Properties().setNoRepair().stacksTo(1).component(DataComponentsInit.UPGRADE_ITEM, (Object)UpgradeItem.EMPTY).component(DataComponentsInit.ENERGY, (Object)0.0).component(DataComponentsInit.MODE, (Object)0).attributes(DiggerItem.createAttributes((Tier)Tiers.IRON, (float)Tiers.IRON.getAttackDamageBonus(), (float)Tiers.IRON.getSpeed())));
        this.name = name;
        this.type = type;
        this.name_type = type.getType_name() == null ? type.name().toLowerCase() : type.getType_name();
        this.transferLimit = variety.getEnergy_transfer();
        this.maxCharge = variety.getCapacity();
        this.tier = variety.getTier();
        this.efficiency = this.normalPower = variety.getNormal_power();
        this.bigHolePower = variety.getBig_holes();
        this.energyPerOperation = variety.getEnergyPerOperation();
        this.energyBigHolePowerOperation = variety.getEnergyPerBigOperation();
        this.energyPerbigHolePowerOperation = variety.getEnergyPerbigHolePowerOperation();
        this.energyPerultraLowPowerOperation = variety.getEnergyPerultraLowPowerOperation();
        this.ultraLowPower = variety.getMega_holes();
        this.ultraLowPower1 = variety.getUltra_power();
        this.mineableBlocks = type.getMineableBlocks();
        this.toolType = type.getToolType();
        this.operations = type.getListOperations();
        this.item_tools = type.getListItems();
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe(this, type.getEnumInfoUpgradeModules()));
    }

    @Override
    public int getMaxLevel(ItemStack stack) {
        int maxLevel = LevelInstruments.super.getMaxLevel(stack);
        if (maxLevel == Integer.MAX_VALUE) {
            return maxLevel;
        }
        maxLevel = (int)((double)maxLevel * Math.max(0.5, 0.5 * (double)this.tier));
        return maxLevel;
    }

    public boolean onDestroyed(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        List<UpgradeItemInform> upgradeItemInforms;
        float energy;
        Block block = state.getBlock();
        if (block.equals(Blocks.AIR)) {
            return false;
        }
        if (state.liquid() || state.getBlock().defaultDestroyTime() == 0.0f && !((Player)entity).isCreative()) {
            return false;
        }
        if (!world.isClientSide) {
            if (CommonHooks.fireBlockBreak((Level)world, (GameType)((ServerPlayer)entity).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)entity), (BlockPos)pos, (BlockState)state).isCanceled()) {
                return false;
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (block.onDestroyedByPlayer(state, world, pos, (Player)((ServerPlayer)entity), true, world.getFluidState(pos))) {
                List<UpgradeItemInform> upgradeItemInforms2 = UpgradeSystem.system.getInformation(stack);
                boolean smelter = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SMELTER, stack, upgradeItemInforms2);
                boolean comb = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.COMB_MACERATOR, stack, upgradeItemInforms2);
                boolean mac = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.MACERATOR, stack, upgradeItemInforms2);
                boolean generator = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENERATOR, stack, upgradeItemInforms2);
                int random = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RANDOM, stack, upgradeItemInforms2) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RANDOM, (ItemStack)stack, upgradeItemInforms2).number : 0;
                boolean black_list = (Boolean)stack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false);
                block.destroy((LevelAccessor)world, pos, state);
                block.playerDestroy(world, (Player)((ServerPlayer)entity), pos, state, blockEntity, stack);
                List items = entity.level().getEntitiesOfClass(ItemEntity.class, new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)));
                this.addExperience(stack, 1);
                if (!black_list && this.check_list(block, 0, UpgradeSystem.system.getBlackList(stack))) {
                    int rand;
                    for (ItemEntity item : items) {
                        RecipeOutput rec;
                        if (entity.level().isClientSide) continue;
                        ItemStack stack1 = item.getItem();
                        if (comb) {
                            rec = Recipes.recipes.getRecipeOutput((String)"comb_macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output;
                            if (rec != null) {
                                stack1 = rec.items.get(0).copy();
                                stack1.setCount(3);
                            }
                        } else if (mac && (rec = Recipes.recipes.getRecipeOutput((String)"macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output) != null) {
                            stack1 = rec.items.get(0).copy();
                        }
                        ItemStack smelt = new ItemStack((ItemLike)Items.AIR);
                        if (smelter && !(smelt = ModUtils.getRecipeFromType(world, stack1, (RecipeType<SmeltingRecipe>)RecipeType.SMELTING)).isEmpty()) {
                            smelt.setCount(stack1.getCount());
                        }
                        if (generator) {
                            boolean rec2;
                            int fuel = ModUtils.getFuelValue(stack1, false);
                            boolean bl = rec2 = fuel > 0;
                            if (rec2) {
                                int amount = stack1.getCount();
                                int value = fuel / 4;
                                amount *= value;
                                amount = (int)((float)amount * 10.0f);
                                double sentPacket = ElectricItem.manager.charge(stack, amount, Integer.MAX_VALUE, true, false);
                                amount = (int)((double)amount - sentPacket);
                                amount = (int)((float)amount / ((float)value * 10.0f));
                                stack1.setCount(amount);
                            }
                        }
                        if (!smelt.isEmpty()) {
                            item.setItem(smelt);
                        } else {
                            item.setItem(stack1);
                        }
                        item.moveTo(entity.getX(), entity.getY(), entity.getZ(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).connection.send((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.setPickUpDelay(0);
                    }
                    if (random != 0 && (rand = world.random.nextInt(100001)) >= 100000 - random) {
                        ItemEntity item;
                        item = new ItemEntity(EntityType.ITEM, world);
                        item.setItem(IUCore.get_ingot.get(world.random.nextInt(IUCore.get_ingot.size())));
                        item.moveTo(entity.getX(), entity.getY(), entity.getZ(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).connection.send((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.setPickUpDelay(0);
                    }
                } else {
                    int rand;
                    if (((Boolean)stack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false)).booleanValue()) {
                        for (ItemEntity item : items) {
                            if (entity.level().isClientSide) continue;
                            item.remove(Entity.RemovalReason.KILLED);
                        }
                    }
                    if (random != 0 && (rand = world.random.nextInt(100001)) >= 100000 - random) {
                        ItemEntity item;
                        item = new ItemEntity(EntityType.ITEM, world);
                        item.setItem(IUCore.get_ingot.get(world.random.nextInt(IUCore.get_ingot.size())));
                        item.moveTo(entity.getX(), entity.getY(), entity.getZ(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).connection.send((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.setPickUpDelay(0);
                    }
                }
            }
        } else if (block.onDestroyedByPlayer(state, world, pos, (Player)entity, true, world.getFluidState(pos))) {
            block.destroy((LevelAccessor)world, pos, state);
        }
        if (entity.isAlive() && (energy = this.energy(stack, upgradeItemInforms = UpgradeSystem.system.getInformation(stack))) != 0.0f) {
            ElectricItem.manager.use(stack, energy, entity);
        }
        return true;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (IUCore.keyboard.isSaveModeKeyDown(player)) {
            boolean save;
            boolean bl = save = (Boolean)itemStack.getOrDefault(DataComponentsInit.SAVE, (Object)false) == false;
            if (!worldIn.isClientSide) {
                CommonProxy.sendPlayerMessage(player, String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.savemode") + (save ? Localization.translate("message.allow") : Localization.translate("message.disallow")));
            }
            itemStack.set(DataComponentsInit.SAVE, (Object)save);
        }
        if (IUCore.keyboard.isBlackListModeKeyDown(player)) {
            boolean black;
            boolean bl = black = (Boolean)itemStack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false) == false;
            if (!worldIn.isClientSide) {
                CommonProxy.sendPlayerMessage(player, String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.blacklist") + (black ? Localization.translate("message.allow") : Localization.translate("message.disallow")));
            }
            itemStack.set(DataComponentsInit.BLACK_LIST, (Object)black);
        }
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            int toolMode = this.readToolMode(itemStack) + 1;
            if (!worldIn.isClientSide) {
                worldIn.playSound(null, player.getX(), player.getY(), player.getZ(), EnumSound.toolchange.getSoundEvent(), SoundSource.MASTER, 1.0f, 1.0f);
            }
            if (toolMode >= this.operations.size()) {
                toolMode = 0;
            }
            this.saveToolMode(itemStack, toolMode);
            EnumOperations operation = this.operations.get(toolMode);
            if (!worldIn.isClientSide) {
                IUCore.proxy.messagePlayer(player, String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode") + ": " + String.valueOf(operation.getTextFormatting()) + Localization.translate(operation.getName_mode()));
            }
            switch (operation) {
                case ORE: 
                case TREE: 
                case SHEARS: 
                case TUNNEL: 
                case DEFAULT: {
                    this.efficiency = this.normalPower;
                    break;
                }
                case BIGHOLES: {
                    this.efficiency = this.bigHolePower;
                    break;
                }
                case MEGAHOLES: {
                    this.efficiency = this.ultraLowPower;
                    break;
                }
                case ULTRAHOLES: {
                    this.efficiency = this.ultraLowPower1;
                }
            }
            return InteractionResultHolder.success((Object)itemStack);
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public int readToolMode(ItemStack itemstack) {
        int toolMode = (Integer)itemstack.get(DataComponentsInit.MODE);
        if (toolMode < 0 || toolMode >= this.operations.size()) {
            toolMode = 0;
        }
        return toolMode;
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int slot, boolean par5) {
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemBlackListLoad(world, this, itemStack, ModUtils.nbt(itemStack)));
        }
        if (entity instanceof Player && IUCore.keyboard.isBlackListModeViewKeyDown((Player)entity) && !entity.level().isClientSide && !itemStack.isEmpty() && ((Player)entity).getItemInHand(InteractionHand.MAIN_HAND).is(itemStack.getItem())) {
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer(entity.registryAccess());
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            ((Player)entity).openMenu((MenuProvider)this.getInventory((Player)entity, itemStack), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
    }

    public boolean hurtEnemy(ItemStack p_41395_, LivingEntity p_41396_, LivingEntity p_41397_) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean isBookEnchantable(@Nonnull ItemStack stack, @Nonnull ItemStack book) {
        return false;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public void appendHoverText(ItemStack par1ItemStack, @Nullable Item.TooltipContext p_41422_, List<Component> par3List, TooltipFlag p_41424_) {
        super.appendHoverText(par1ItemStack, p_41422_, par3List, p_41424_);
        int toolMode = this.readToolMode(par1ItemStack);
        EnumOperations operations = this.operations.get(toolMode);
        par3List.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Localization.translate("message.text.mode") + ": " + String.valueOf(operations.getTextFormatting()) + Localization.translate(operations.getName_mode()))));
        par3List.add((Component)Component.translatable((String)operations.getDescription()));
        if (((Boolean)par1ItemStack.getOrDefault(DataComponentsInit.SAVE, (Object)false)).booleanValue()) {
            par3List.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.savemode_allow"))));
        }
        if (((Boolean)par1ItemStack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false)).booleanValue()) {
            par3List.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.DARK_GRAY) + Localization.translate("iu.blacklist_allow"))));
        }
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(par1ItemStack);
        if (operations != EnumOperations.DEFAULT && operations != EnumOperations.ORE && operations != EnumOperations.TREE) {
            int aoe = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, par1ItemStack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)par1ItemStack, upgradeItemInforms).number : 0;
            int dig_depth = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, par1ItemStack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)par1ItemStack, upgradeItemInforms).number : 0;
            par3List.add((Component)Component.literal((String)(Localization.translate("iu.instruments.info") + (operations.getArea_x() + aoe) + "x" + (operations.getArea_y() + aoe) + "x" + (operations.getArea_z() + dig_depth))));
        }
        float energy = this.energy(par1ItemStack, upgradeItemInforms);
        par3List.add((Component)Component.literal((String)(Localization.translate("iu.instruments.info2") + (int)energy + " EF")));
        if (!KeyboardIU.isKeyDown(340)) {
            par3List.add((Component)Component.literal((String)Localization.translate("press.lshift")));
        }
        if (KeyboardIU.isKeyDown(340)) {
            par3List.add((Component)Component.literal((String)(Localization.translate("iu.changemode_key") + KeyboardClient.changemode.getKey().getDisplayName().getString() + Localization.translate("iu.changemode_rcm"))));
            par3List.add((Component)Component.literal((String)(Localization.translate("iu.blacklist_key") + KeyboardClient.blackmode.getKey().getDisplayName().getString() + Localization.translate("iu.changemode_rcm"))));
            par3List.add((Component)Component.literal((String)(Localization.translate("iu.savemode_key") + KeyboardClient.savemode.getKey().getDisplayName().getString() + Localization.translate("iu.changemode_rcm"))));
            par3List.add((Component)Component.literal((String)(Localization.translate("iu.blacklist_gui") + KeyboardClient.blacklistviewmode.getKey().getDisplayName().getString())));
        }
        ModUtils.mode(par1ItemStack, par3List);
        int level = this.getLevel(par1ItemStack);
        int maxLevel = this.getMaxLevel(par1ItemStack);
        int experience = this.getExperience(par1ItemStack);
        par3List.add((Component)Component.literal((String)(Localization.translate("circuit.level") + ": " + level)));
        par3List.add((Component)Component.literal((String)(Localization.translate("iu.space_colony_experience") + experience + "/" + maxLevel)));
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    @Nonnull
    public Set<String> getToolClasses(@Nonnull ItemStack stack) {
        return this.toolType;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.mineableBlocks.contains(state)) {
            return true;
        }
        for (TagKey<Block> blockTagKey : this.item_tools) {
            if (!state.is(blockTagKey)) continue;
            return true;
        }
        return false;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        int speed;
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
        int n = speed = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.EFFICIENCY, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EFFICIENCY, (ItemStack)stack, upgradeItemInforms).number : 0;
        return !ElectricItem.manager.canUse(stack, this.energy(stack, upgradeItemInforms)) ? 0.0f : (this.isCorrectToolForDrops(stack, state) ? (float)(this.efficiency + (int)((double)this.efficiency * 0.2 * (double)speed)) : 1.0f);
    }

    void chopTree(BlockPos pos, Player player, Level world, ItemStack stack, List<BlockPos> list, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        int Y = pos.getY();
        int X = pos.getX();
        int Z = pos.getZ();
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= Y + 1; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    BlockPos pos1 = new BlockPos(xPos, yPos, zPos);
                    if (list.contains(pos1)) continue;
                    BlockState state = world.getBlockState(pos1);
                    Block block = state.getBlock();
                    list.add(pos1);
                    if (!state.is(BlockTags.LOGS)) continue;
                    if (!player.isCreative()) {
                        this.onBlockDestroyed(stack, world, state, pos1, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                    }
                    this.chopTree(pos1, player, world, stack, list, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
            }
        }
    }

    private boolean isTree(Level world, BlockPos pos) {
        Block wood = world.getBlockState(pos).getBlock();
        if (wood.equals(Blocks.AIR) || !wood.builtInRegistryHolder().is(BlockTags.LOGS)) {
            return false;
        }
        int top = pos.getY();
        int Y = pos.getY();
        int X = pos.getX();
        int Z = pos.getZ();
        for (int y = pos.getY(); y <= pos.getY() + 50; ++y) {
            BlockPos pos1 = new BlockPos(X, y, Z);
            BlockState blockstate = world.getBlockState(pos1);
            if (blockstate.is(BlockTags.LOGS) || blockstate.is(BlockTags.LEAVES)) continue;
            top += y;
            break;
        }
        int leaves = 0;
        for (int xPos = X - 1; xPos <= X + 1; ++xPos) {
            for (int yPos = Y; yPos <= top; ++yPos) {
                for (int zPos = Z - 1; zPos <= Z + 1; ++zPos) {
                    BlockPos pos1 = new BlockPos(xPos, yPos, zPos);
                    BlockState blockstate = world.getBlockState(pos1);
                    if (!blockstate.is(BlockTags.LEAVES)) continue;
                    ++leaves;
                }
            }
        }
        return leaves >= 3;
    }

    boolean break_block(Level world, Block block, BlockHitResult mop, byte mode_item, Player player, BlockPos pos, ItemStack stack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        byte xRange = mode_item;
        byte yRange = mode_item;
        byte zRange = mode_item;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        byte dig_depth = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0);
        switch (mop.getDirection().ordinal()) {
            case 0: 
            case 1: {
                yRange = dig_depth;
                break;
            }
            case 2: 
            case 3: {
                zRange = dig_depth;
                break;
            }
            case 4: 
            case 5: {
                xRange = dig_depth;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)stack);
        int Yy = yRange > 0 ? yRange - 1 : 0;
        float energy = this.energy(stack, upgradeItemInforms);
        boolean save = (Boolean)stack.getOrDefault(DataComponentsInit.SAVE, (Object)false);
        if (!player.isCreative()) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block6: for (int yPos = y - yRange + Yy; yPos <= y + yRange + Yy; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, energy)) {
                            BlockState state;
                            Block localBlock;
                            BlockPos pos_block = new BlockPos(xPos, yPos, zPos);
                            if (save && world.getBlockEntity(pos_block) != null || (localBlock = (state = world.getBlockState(pos_block)).getBlock()).equals(Blocks.AIR) || !this.isCorrectToolForDrops(stack, state) || !(state.getDestroySpeed((BlockGetter)world, pos_block) >= 0.0f)) continue;
                            if (state.getDestroySpeed((BlockGetter)world, pos_block) >= 0.0f) {
                                this.onBlockDestroyed(stack, world, state, pos_block, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                            }
                            if (silktouch) continue;
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, (Entity)player, stack, localBlock));
                            continue;
                        }
                        lowPower = true;
                        continue block6;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.getBlockState(pos);
            Block localBlock = state.getBlock();
            if (!localBlock.equals(Blocks.AIR) && this.isCorrectToolForDrops(stack, state) && state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f || block == Blocks.SPAWNER) {
                if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, (Entity)player, stack, localBlock));
                }
            } else if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
            }
        }
        if (lowPower && ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.getBlockState(pos);
            Block localBlock = state.getBlock();
            if (!localBlock.equals(Blocks.AIR) && this.isCorrectToolForDrops(stack, state) && state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f || block == Blocks.SPAWNER) {
                if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, (Entity)player, stack, localBlock));
                }
            } else if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, blackList);
            }
        }
        return true;
    }

    public boolean mineBlock(ItemStack stack, Level p_41417_, BlockState state, BlockPos pos, LivingEntity p_41420_) {
        if (!(p_41420_ instanceof Player)) {
            return false;
        }
        Player player = (Player)p_41420_;
        EnumOperations operations = this.operations.get(this.readToolMode(stack));
        Level world = player.level();
        Block block = state.getBlock();
        BlockHitResult mop = RetraceDiggingUtils.retrace(player);
        List<UpgradeItemInform> upgradeItemInforms = UpgradeSystem.system.getInformation(stack);
        boolean smelter = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SMELTER, stack, upgradeItemInforms);
        boolean comb = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.COMB_MACERATOR, stack, upgradeItemInforms);
        boolean mac = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.MACERATOR, stack, upgradeItemInforms);
        boolean generator = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.GENERATOR, stack, upgradeItemInforms);
        int random = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RANDOM, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RANDOM, (ItemStack)stack, upgradeItemInforms).number : 0;
        boolean black_list = (Boolean)stack.getOrDefault(DataComponentsInit.BLACK_LIST, (Object)false);
        List<String> list = UpgradeSystem.system.getBlackList(stack);
        switch (operations) {
            case DEFAULT: {
                if (block == Blocks.AIR) {
                    return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case BIGHOLES: {
                if (block.equals(Blocks.AIR)) {
                    return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.isShiftKeyDown() && !mop.getType().equals((Object)HitResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(1 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case MEGAHOLES: {
                if (block.equals(Blocks.AIR)) {
                    return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.isShiftKeyDown() && !mop.getType().equals((Object)HitResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(2 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case ULTRAHOLES: {
                if (block.equals(Blocks.AIR)) {
                    return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                if (player.isShiftKeyDown() && !mop.getType().equals((Object)HitResult.Type.MISS)) {
                    return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)(3 + aoe), player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case ORE: {
                if (block.equals(Blocks.AIR)) {
                    return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
                }
                boolean silktouch = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack) > 0;
                int fortune = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)stack);
                CompoundTag nbt = ModUtils.nbt(stack);
                nbt.putInt("ore", 1);
                float energy = this.energy(stack, upgradeItemInforms);
                if (!mop.getType().equals((Object)HitResult.Type.MISS)) {
                    this.ore_break(world, pos, player, silktouch, fortune, false, stack, block, smelter, comb, mac, generator, random, black_list, energy, list);
                    return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case TREE: {
                if (this.isTree(player.level(), pos)) {
                    ArrayList<BlockPos> list1 = new ArrayList<BlockPos>();
                    float energy = this.energy(stack, upgradeItemInforms);
                    this.chopTree(pos, player, player.level(), stack, list1, energy, smelter, comb, mac, generator, random, black_list, list);
                    return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                return this.break_block(world, block, mop, (byte)0, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case TUNNEL: {
                if (block == Blocks.AIR) {
                    return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
                }
                return this.break_block_tunel(world, block, mop, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
            case SHEARS: {
                if (block == Blocks.AIR) {
                    return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
                }
                if (block.builtInRegistryHolder().is(BlockTags.LEAVES)) {
                    return this.break_shears(world, block, mop, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
                }
                byte aoe = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.AOE_DIG, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.AOE_DIG, (ItemStack)stack, upgradeItemInforms).number : 0);
                return this.break_block(world, block, mop, aoe, player, pos, stack, upgradeItemInforms, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        return false;
    }

    private boolean break_shears(Level world, Block block, BlockHitResult mop, Player player, BlockPos pos, ItemStack itemstack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean blackList, List<String> list) {
        float energy = this.energy(itemstack, upgradeItemInforms);
        BlockState state = world.getBlockState(pos);
        if (state.is(BlockTags.LEAVES) && ElectricItem.manager.use(itemstack, energy, (LivingEntity)player) && !block.equals(Blocks.AIR) && this.isCorrectToolForDrops(itemstack, state) && state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f && state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
            this.onBlockDestroyed(itemstack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, blackList, list, true);
            return true;
        }
        return false;
    }

    private boolean break_block_tunel(Level world, Block block, BlockHitResult mop, Player player, BlockPos pos, ItemStack stack, List<UpgradeItemInform> upgradeItemInforms, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> list) {
        int xRange = 6;
        int yRange = 6;
        int zRange = 6;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        Direction direction = ItemEnergyInstruments.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE).getDirection();
        switch (direction.ordinal()) {
            case 0: 
            case 1: {
                xRange = 0;
                zRange = 0;
                break;
            }
            case 2: 
            case 3: {
                xRange = 0;
                yRange = 0;
                break;
            }
            case 4: 
            case 5: {
                zRange = 0;
                yRange = 0;
            }
        }
        boolean lowPower = false;
        boolean silktouch = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)stack);
        CompoundTag nbt = ModUtils.nbt(stack);
        float energy = this.energy(stack, upgradeItemInforms);
        byte dig_depth = (byte)(UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.DIG_DEPTH, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.DIG_DEPTH, (ItemStack)stack, upgradeItemInforms).number : 0);
        if (dig_depth > 0) {
            if (zRange > 0) {
                xRange = dig_depth;
            } else {
                zRange = xRange > 0 ? (int)dig_depth : (int)dig_depth;
            }
        }
        boolean save = nbt.getBoolean("save");
        if (!player.isCreative()) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                block6: for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                        if (ElectricItem.manager.canUse(stack, energy)) {
                            BlockState state;
                            Block localBlock;
                            BlockPos pos_block = new BlockPos(xPos, yPos, zPos);
                            if (save && world.getBlockEntity(pos_block) != null || (localBlock = (state = world.getBlockState(pos_block)).getBlock()).equals(Blocks.AIR) || !this.isCorrectToolForDrops(stack, state) || !(state.getDestroySpeed((BlockGetter)world, pos_block) >= 0.0f)) continue;
                            if (state.getDestroySpeed((BlockGetter)world, pos_block) >= 0.0f) {
                                this.onBlockDestroyed(stack, world, state, pos_block, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                            }
                            if (silktouch) continue;
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, (Entity)player, stack, localBlock));
                            continue;
                        }
                        lowPower = true;
                        continue block6;
                    }
                }
            }
        } else if (ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.getBlockState(pos);
            Block localBlock = state.getBlock();
            if (!localBlock.equals(Blocks.AIR) && this.isCorrectToolForDrops(stack, state) && state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f || block == Blocks.SPAWNER) {
                if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, (Entity)player, stack, localBlock));
                }
            } else if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        if (lowPower && ElectricItem.manager.canUse(stack, energy)) {
            BlockState state = world.getBlockState(pos);
            Block localBlock = state.getBlock();
            if (!localBlock.equals(Blocks.AIR) && this.isCorrectToolForDrops(stack, state) && state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f || block == Blocks.SPAWNER) {
                if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                    this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                }
                if (!silktouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos, (Entity)player, stack, localBlock));
                }
            } else if (state.getDestroySpeed((BlockGetter)world, pos) >= 0.0f) {
                return this.onBlockDestroyed(stack, world, state, pos, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
            }
        }
        return true;
    }

    private void ore_break(Level world, BlockPos pos, Player player, boolean silktouch, int fortune, boolean lowPower, ItemStack stack, Block block1, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, float energy, List<String> list) {
        CompoundTag NBTTagCompound = ModUtils.nbt(stack);
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        for (int Xx = x - 2; Xx <= x + 2; ++Xx) {
            block1: for (int Yy = y - 2; Yy <= y + 2; ++Yy) {
                for (int Zz = z - 2; Zz <= z + 2; ++Zz) {
                    BlockPos pos_block;
                    BlockState state;
                    Block localBlock;
                    int ore = NBTTagCompound.getInt("ore");
                    if (ore >= 32 || !ModUtils.getore(localBlock = (state = world.getBlockState(pos_block = new BlockPos(Xx, Yy, Zz))).getBlock(), block1)) continue;
                    if (ElectricItem.manager.canUse(stack, energy)) {
                        if (player.isCreative()) continue block1;
                        if (state.getDestroySpeed((BlockGetter)world, pos_block) >= 0.0f) {
                            this.onBlockDestroyed(stack, world, state, pos_block, (LivingEntity)player, energy, smelter, comb, mac, generator, random, black_list, list);
                        }
                        if (!silktouch) {
                            ExperienceUtils.addPlayerXP(player, this.getExperience(state, world, pos_block, (Entity)player, stack, localBlock));
                        }
                        NBTTagCompound.putInt("ore", ++ore);
                        this.ore_break(world, pos_block, player, silktouch, fortune, lowPower, stack, block1, smelter, comb, mac, generator, random, black_list, energy, list);
                        continue;
                    }
                    lowPower = true;
                    continue block1;
                }
            }
        }
    }

    private int getExperience(BlockState state, Level world, BlockPos pos_block, Entity entity, ItemStack stack, Block localBlock) {
        int col = localBlock.getExpDrop(state, (LevelAccessor)world, pos_block, null, entity, stack);
        col = (int)((double)col * (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.EXPERIENCE, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EXPERIENCE, (ItemStack)stack).number * 0.5 + 1.0 : 1.0));
        return col;
    }

    public boolean onBlockDestroyed(@Nonnull ItemStack stack, @Nonnull Level world, BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList) {
        return this.onBlockDestroyed(stack, world, state, pos, entity, energy, smelter, comb, mac, generator, random, black_list, blackList, false);
    }

    public boolean onBlockDestroyed(@Nonnull ItemStack stack, @Nonnull Level world, BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity, float energy, boolean smelter, boolean comb, boolean mac, boolean generator, int random, boolean black_list, List<String> blackList, boolean shears) {
        Block block = state.getBlock();
        if (block.equals(Blocks.AIR)) {
            return false;
        }
        if (state.liquid() || state.getBlock().defaultDestroyTime() == 0.0f && !((Player)entity).isCreative()) {
            return false;
        }
        if (!world.isClientSide) {
            int rand;
            if (CommonHooks.fireBlockBreak((Level)world, (GameType)((ServerPlayer)entity).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)entity), (BlockPos)pos, (BlockState)state).isCanceled()) {
                return false;
            }
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (block.onDestroyedByPlayer(state, world, pos, (Player)((ServerPlayer)entity), true, world.getFluidState(pos))) {
                block.destroy((LevelAccessor)world, pos, state);
                block.playerDestroy(world, (Player)((ServerPlayer)entity), pos, state, blockEntity, stack);
                CompoundTag nbt = ModUtils.nbt(stack);
                List items = entity.level().getEntitiesOfClass(ItemEntity.class, new AABB((double)(pos.getX() - 1), (double)(pos.getY() - 1), (double)(pos.getZ() - 1), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1)));
                this.addExperience(stack, 1);
                if (!black_list || ModUtils.getore(block, block) && this.check_list(block, 0, blackList)) {
                    for (ItemEntity item : items) {
                        RecipeOutput rec;
                        if (entity.level().isClientSide) continue;
                        ItemStack stack1 = item.getItem();
                        if (comb) {
                            rec = Recipes.recipes.getRecipeOutput((String)"comb_macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output;
                            if (rec != null) {
                                stack1 = rec.items.get(0).copy();
                                stack1.setCount(3);
                            }
                        } else if (mac && (rec = Recipes.recipes.getRecipeOutput((String)"macerator", (boolean)false, (ItemStack[])new ItemStack[]{stack1}).output) != null) {
                            stack1 = rec.items.get(0).copy();
                        }
                        ItemStack smelt = new ItemStack((ItemLike)Items.AIR);
                        if (smelter && !(smelt = ModUtils.getRecipeFromType(world, stack1, (RecipeType<SmeltingRecipe>)RecipeType.SMELTING)).isEmpty()) {
                            smelt.setCount(stack1.getCount());
                        }
                        if (generator) {
                            boolean rec2;
                            int fuel = ModUtils.getFuelValue(stack1, false);
                            boolean bl = rec2 = fuel > 0;
                            if (rec2) {
                                int amount = stack1.getCount();
                                int value = fuel / 4;
                                amount *= value;
                                amount = (int)((float)amount * 10.0f);
                                double sentPacket = ElectricItem.manager.charge(stack, amount, Integer.MAX_VALUE, true, false);
                                amount = (int)((double)amount - sentPacket);
                                amount = (int)((float)amount / ((float)value * 10.0f));
                                stack1.setCount(amount);
                            }
                        }
                        if (!smelt.isEmpty()) {
                            item.setItem(smelt);
                        } else {
                            item.setItem(stack1);
                        }
                        item.moveTo(entity.getX(), entity.getY(), entity.getZ(), 0.0f, 0.0f);
                        ((ServerPlayer)entity).connection.send((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                        item.setPickUpDelay(0);
                    }
                } else if (nbt.getBoolean("black")) {
                    for (ItemEntity item : items) {
                        if (entity.level().isClientSide) continue;
                        item.remove(Entity.RemovalReason.KILLED);
                    }
                }
            }
            if (random != 0 && (rand = world.random.nextInt(100001)) >= 100000 - random) {
                ItemEntity item = new ItemEntity(EntityType.ITEM, world);
                item.setItem(IUCore.get_ingot.get(world.random.nextInt(IUCore.get_ingot.size())));
                item.moveTo(entity.getX(), entity.getY(), entity.getZ(), 0.0f, 0.0f);
                ((ServerPlayer)entity).connection.send((Packet)new ClientboundTeleportEntityPacket((Entity)item));
                item.setPickUpDelay(0);
            }
        } else {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (block.onDestroyedByPlayer(state, world, pos, (Player)entity, true, world.getFluidState(pos))) {
                block.destroy((LevelAccessor)world, pos, state);
                block.playerDestroy(world, (Player)entity, pos, state, blockEntity, stack);
            }
        }
        if (entity.isAlive() && energy != 0.0f) {
            ElectricItem.manager.use(stack, energy, entity);
        }
        return true;
    }

    @Override
    public CustomWorldContainer getInventory(Player player, ItemStack stack) {
        return new ItemStackUpgradeItem(player, stack);
    }

    public boolean check_list(Block block, int metaFromState, List<String> blackList) {
        if (blackList.isEmpty()) {
            return true;
        }
        ItemStack stack1 = new ItemStack((ItemLike)block, 1);
        if (stack1.isEmpty()) {
            return true;
        }
        List list = stack1.getTags().toList();
        if (list.isEmpty()) {
            return true;
        }
        String name = ((TagKey)list.get(0)).location().toString();
        return !blackList.contains(name);
    }

    public void saveToolMode(ItemStack itemstack, int toolMode) {
        itemstack.set(DataComponentsInit.MODE, (Object)toolMode);
    }

    public float energy(ItemStack stack, List<UpgradeItemInform> upgradeItemInforms) {
        int energy1 = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack, upgradeItemInforms) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack, upgradeItemInforms).number : 0;
        int toolMode = this.readToolMode(stack);
        EnumOperations operations = this.operations.get(toolMode);
        float energy = switch (operations) {
            case EnumOperations.BIGHOLES -> (float)((double)this.energyBigHolePowerOperation - (double)this.energyBigHolePowerOperation * 0.25 * (double)energy1);
            case EnumOperations.MEGAHOLES -> (float)((double)this.energyPerbigHolePowerOperation - (double)this.energyPerbigHolePowerOperation * 0.25 * (double)energy1);
            case EnumOperations.ULTRAHOLES -> (float)((double)this.energyPerultraLowPowerOperation - (double)this.energyPerultraLowPowerOperation * 0.25 * (double)energy1);
            default -> (float)((double)this.energyPerOperation - (double)this.energyPerOperation * 0.25 * (double)energy1);
        };
        return energy;
    }

    public InteractionResult useOn(UseOnContext p_41427_) {
        Player player = p_41427_.getPlayer();
        if (this.toolType.contains("pickaxe")) {
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                boolean result;
                Item item;
                ItemStack torchStack = (ItemStack)player.getInventory().items.get(i);
                if (torchStack.isEmpty() || !torchStack.is(Items.TORCH) || !((item = torchStack.getItem()) instanceof BlockItem)) continue;
                UseOnContext useOnContext = new UseOnContext(p_41427_.getLevel(), p_41427_.getPlayer(), p_41427_.getHand(), torchStack, new BlockHitResult(p_41427_.getClickLocation(), p_41427_.getClickedFace(), p_41427_.getClickedPos(), p_41427_.isInside()));
                boolean bl = result = torchStack.getItem().useOn(useOnContext) == InteractionResult.SUCCESS;
                if (!result) continue;
                torchStack.setCount(torchStack.getCount() - 1);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public List<EnumOperations> getOperations() {
        return this.operations;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return this.type.getEnumInfoUpgradeModules();
    }

    @Override
    public String[] properties() {
        return new String[]{"mode"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        String[] mode = new String[]{"", "Zelen", "Demon", "Dark", "Cold", "Ender", "Ukraine", "Fire", "Snow", "Taiga", "Desert", "Emerald"};
        for (int i = 0; i < mode.length; ++i) {
            if (!((String)stack.getOrDefault(DataComponentsInit.SKIN, (Object)"")).equals(mode[i])) continue;
            return i;
        }
        return 0.0f;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> items) {
        if (this.allowedIn(p_41391_)) {
            ItemStack stack = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(stack, 2.147483647E9, Integer.MAX_VALUE, true, false);
            items.add((Object)stack);
            ItemStack itemstack = new ItemStack((ItemLike)this, 1);
            items.add((Object)itemstack);
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }
}

