/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.BlockRubWood;
import com.denfop.blocks.BlockSwampRubWood;
import com.denfop.blocks.BlockTropicalRubWood;
import com.denfop.sound.EnumSound;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.DamageHandler;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class ItemTreetap
extends Item
implements IItemTab {
    private String nameItem;

    public ItemTreetap() {
        super(new Item.Properties().durability(16).setNoRepair());
    }

    public static boolean attemptExtract(Player player, Level world, BlockPos pos, Direction side, BlockState state, List<ItemStack> stacks) {
        if (state.getBlock() != IUItem.rubWood.getBlock().get()) {
            return false;
        }
        BlockRubWood.RubberWoodState rwState = (BlockRubWood.RubberWoodState)((Object)state.getValue(BlockRubWood.stateProperty));
        if (!rwState.isPlain() && rwState.facing == side) {
            if (rwState.wet) {
                if (!world.isClientSide) {
                    world.setBlock(pos, (BlockState)state.setValue(BlockRubWood.stateProperty, (Comparable)((Object)rwState.getDry())), 3);
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, world.random.nextInt(3) + 1);
                    }
                }
                if (world.isClientSide && player != null) {
                    player.playSound(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.isClientSide && world.random.nextInt(5) == 0) {
                world.setBlock(pos, (BlockState)state.setValue(BlockRubWood.stateProperty, (Comparable)((Object)BlockRubWood.RubberWoodState.plain_y)), 3);
            }
            if (world.random.nextInt(5) == 0) {
                if (!world.isClientSide) {
                    ItemTreetap.ejectResin(world, pos, side, 1);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean attemptTropicalExtract(Player player, Level world, BlockPos pos, Direction side, BlockState state, List<ItemStack> stacks) {
        if (state.getBlock() != IUItem.tropicalRubWood.getBlock().get()) {
            return false;
        }
        BlockTropicalRubWood.RubberWoodState rwState = (BlockTropicalRubWood.RubberWoodState)((Object)state.getValue(BlockTropicalRubWood.stateProperty));
        if (!rwState.isPlain() && rwState.facing == side) {
            if (rwState.wet) {
                if (!world.isClientSide) {
                    world.setBlock(pos, (BlockState)state.setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)rwState.getDry())), 3);
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, world.random.nextInt(3) + 1);
                    }
                }
                if (world.isClientSide && player != null) {
                    player.playSound(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.isClientSide && world.random.nextInt(5) == 0) {
                world.setBlock(pos, (BlockState)state.setValue(BlockTropicalRubWood.stateProperty, (Comparable)((Object)BlockTropicalRubWood.RubberWoodState.plain_y)), 3);
            }
            if (world.random.nextInt(5) == 0) {
                if (!world.isClientSide) {
                    ItemTreetap.ejectResin(world, pos, side, 1);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean attemptSwampExtract(Player player, Level world, BlockPos pos, Direction side, BlockState state, List<ItemStack> stacks) {
        if (state.getBlock() != IUItem.swampRubWood.getBlock().get()) {
            return false;
        }
        BlockSwampRubWood.RubberWoodState rwState = (BlockSwampRubWood.RubberWoodState)((Object)state.getValue(BlockSwampRubWood.stateProperty));
        if (!rwState.isPlain() && rwState.facing == side) {
            if (rwState.wet) {
                if (!world.isClientSide) {
                    world.setBlock(pos, (BlockState)state.setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)rwState.getDry())), 3);
                    if (stacks == null) {
                        ItemTreetap.ejectResin(world, pos, side, world.random.nextInt(3) + 1);
                    }
                }
                if (world.isClientSide && player != null) {
                    player.playSound(EnumSound.Treetap.getSoundEvent(), 1.0f, 1.0f);
                }
                return true;
            }
            if (!world.isClientSide && world.random.nextInt(5) == 0) {
                world.setBlock(pos, (BlockState)state.setValue(BlockSwampRubWood.stateProperty, (Comparable)((Object)BlockSwampRubWood.RubberWoodState.plain_y)), 3);
            }
            if (world.random.nextInt(5) == 0) {
                if (!world.isClientSide) {
                    ItemTreetap.ejectResin(world, pos, side, 1);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private static void ejectResin(Level world, BlockPos pos, Direction side, int quantity) {
        double ejectX = (double)pos.getX() + 0.5 + (double)side.getStepX() * 0.3;
        double ejectY = (double)pos.getY() + 0.5 + (double)side.getStepY() * 0.3;
        double ejectZ = (double)pos.getZ() + 0.5 + (double)side.getStepZ() * 0.3;
        ItemEntity itemEntity = new ItemEntity(world, ejectX, ejectY, ejectZ, new ItemStack((ItemLike)IUItem.rawLatex.getItem(), quantity));
        world.addFreshEntity((Entity)itemEntity);
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.treetap.info")));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() == IUItem.rubWood.getBlock().get()) {
            if (ItemTreetap.attemptExtract(player, world, pos, side, state, null)) {
                if (!world.isClientSide) {
                    DamageHandler.damage(player.getItemInHand(context.getHand()), 1, (LivingEntity)player);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (state.getBlock() == IUItem.swampRubWood.getBlock().get()) {
            if (ItemTreetap.attemptSwampExtract(player, world, pos, side, state, null)) {
                if (!world.isClientSide) {
                    DamageHandler.damage(player.getItemInHand(context.getHand()), 1, (LivingEntity)player);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (state.getBlock() == IUItem.tropicalRubWood.getBlock().get()) {
            if (ItemTreetap.attemptTropicalExtract(player, world, pos, side, state, null)) {
                if (!world.isClientSide) {
                    DamageHandler.damage(player.getItemInHand(context.getHand()), 1, (LivingEntity)player);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }
}

