/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.IUCore;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.api.item.upgrade.EnumUpgrades;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.armour.special.ItemSpecialArmor;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.tabs.IItemTab;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.NeoForge;

public class ItemKatana
extends TieredItem
implements EnergyItem,
UpgradeItem,
IProperties,
IItemTab {
    public final int maxCharge;
    public final int transferLimit;
    public final int tier;
    public int damage1 = 13;
    private int soundTicker = 0;
    private String nameItem;

    public ItemKatana() {
        super((Tier)Tiers.DIAMOND, new Item.Properties().setNoRepair().setNoRepair().stacksTo(1).component(DataComponentsInit.ENERGY, (Object)0.0).component(DataComponentsInit.ACTIVE, (Object)false).component(DataComponentsInit.MODE, (Object)0).component(DataComponentsInit.SKIN, (Object)"").component(DataComponents.TOOL, (Object)SwordItem.createToolProperties()));
        this.maxCharge = 500000;
        this.transferLimit = 5000;
        this.tier = 4;
        IUCore.proxy.addProperties(this);
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.SABERS.list));
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.katana";
        }
        return this.nameItem;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public String[] properties() {
        return new String[]{"type"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel world, LivingEntity entityIn, int p174679, String property) {
        switch ((String)stack.getOrDefault(DataComponentsInit.SKIN, (Object)"")) {
            case "": {
                return 0.0f;
            }
            case "yellow": {
                return 0.25f;
            }
            case "green": {
                return 0.5f;
            }
            case "pink": {
                return 0.75f;
            }
        }
        return 0.0f;
    }

    public boolean drainSaber(ItemStack itemStack, double amount) {
        int saberenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABERENERGY, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABERENERGY, (ItemStack)itemStack).number : 0;
        return ElectricItem.manager.use(itemStack, amount - amount * 0.15 * (double)saberenergy, null);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxCharge;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return true;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        int saberdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.SABER_DAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.SABER_DAMAGE, (ItemStack)stack).number : 0;
        int dmg = (int)((double)this.damage1 + (double)this.damage1 * 0.15 * (double)saberdamage);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)dmg, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    public boolean hurtEnemy(@Nonnull ItemStack stack, @Nonnull LivingEntity target, @Nonnull LivingEntity source) {
        if (!target.level().isClientSide) {
            if (!this.drainSaber(stack, 400.0)) {
                return false;
            }
            int vampires = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.VAMPIRES, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.VAMPIRES, (ItemStack)stack).number : 0;
            boolean wither = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.WITHER, stack);
            boolean poison = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.POISON, stack);
            if (vampires > 0) {
                target.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 40, vampires));
            }
            if (wither) {
                target.addEffect(new MobEffectInstance(MobEffects.WITHER, 60));
            }
            if (poison) {
                target.addEffect(new MobEffectInstance(MobEffects.POISON, 60));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.HUNGRY, stack)) {
                target.addEffect(new MobEffectInstance(MobEffects.HUNGER, 60));
            }
            if (source instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)source;
                new PacketSoundPlayer("katana", (Player)player);
                boolean iaidoActive = (Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false);
                if (iaidoActive) {
                    player.getCooldowns().addCooldown((Item)this, 60);
                }
            }
            if (!(source instanceof ServerPlayer) || !(target instanceof Player) || ((ServerPlayer)source).canHarmPlayer((Player)target)) {
                Iterator armorSlots = Arrays.stream(EquipmentSlot.values()).filter(slot -> slot != EquipmentSlot.MAINHAND && slot != EquipmentSlot.OFFHAND).iterator();
                while (armorSlots.hasNext()) {
                    EquipmentSlot slot2 = (EquipmentSlot)armorSlots.next();
                    if (!ElectricItem.manager.canUse(stack, 2000.0)) break;
                    ItemStack armor = target.getItemBySlot(slot2);
                    if (armor.isEmpty()) continue;
                    double amount = 0.0;
                    Item item = armor.getItem();
                    if (item instanceof ItemSpecialArmor) {
                        ItemSpecialArmor specialArmor = (ItemSpecialArmor)item;
                        amount = specialArmor.getArmor().getDamageEnergy();
                    }
                    if (!(amount > 0.0)) continue;
                    ElectricItem.manager.discharge(armor, amount, this.tier, true, false, false);
                    if (!ElectricItem.manager.canUse(armor, 1.0)) {
                        target.setItemSlot(slot2, ItemStack.EMPTY);
                    }
                    this.drainSaber(stack, 2000.0);
                }
            }
        }
        return true;
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int slot, boolean p_41408_) {
        super.inventoryTick(itemStack, world, entity, slot, p_41408_);
        CompoundTag nbt = ModUtils.nbt(itemStack);
        if (!UpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.isClientSide) {
                ItemCooldowns cooldownTracker = player.getCooldowns();
                nbt.putBoolean("cooldown", cooldownTracker.isOnCooldown(itemStack.getItem()));
            }
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!IUCore.keyboard.isChangeKeyDown(player)) {
            switch ((String)stack.getOrDefault(DataComponentsInit.SKIN, (Object)"")) {
                case "": {
                    stack.set(DataComponentsInit.SKIN, (Object)"yellow");
                    break;
                }
                case "yellow": {
                    stack.set(DataComponentsInit.SKIN, (Object)"green");
                    break;
                }
                case "green": {
                    stack.set(DataComponentsInit.SKIN, (Object)"pink");
                    break;
                }
                case "pink": {
                    stack.set(DataComponentsInit.SKIN, (Object)"");
                }
            }
        } else {
            stack.set(DataComponentsInit.ACTIVE, (Object)((Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false) == false ? 1 : 0));
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    protected void removeAudioSource() {
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return false;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.SABERS.list;
    }

    public boolean isCorrectToolForDrops(ItemStack p_336002_, BlockState pBlock) {
        return pBlock.is(Blocks.COBWEB);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_SWORD_ACTIONS.contains(itemAbility);
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.transferLimit;
    }

    public boolean onDroppedByPlayer(ItemStack item, Player player) {
        this.removeAudioSource();
        return super.onDroppedByPlayer(item, player);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.translatable((String)"iu.changemode_key").append((Component)Component.translatable((String)Localization.translate("iu.changemode_rcm1"))));
            tooltip.add((Component)Component.translatable((String)"iu.changemode_key").append(KeyboardClient.changemode.getKey().getDisplayName()).append((Component)Component.translatable((String)"iu.changemode_rcm")));
        }
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }
}

