/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.items.energy.ItemEnergyTool;
import com.denfop.utils.ElectricItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ItemEnergyToolHoe
extends ItemEnergyTool {
    public ItemEnergyToolHoe() {
        super(50);
        this.maxCharge = 10000;
        this.transferLimit = 100;
        this.tier = 1;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        return ItemAbilities.DEFAULT_HOE_ACTIONS.contains(itemAbility);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        ItemStack stack = context.getItemInHand();
        if (player == null || !player.mayUseItemAt(pos, context.getClickedFace(), stack)) {
            return InteractionResult.PASS;
        }
        if (!ElectricItem.manager.canUse(stack, this.operationEnergyCost)) {
            return InteractionResult.PASS;
        }
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (context.getClickedFace() == Direction.DOWN || !world.getBlockState(pos.below()).isAir() && block != Blocks.MYCELIUM && block != Blocks.GRASS_BLOCK && block != Blocks.DIRT) {
            return super.useOn(context);
        }
        Block farmland = Blocks.FARMLAND;
        SoundType stepSound = farmland.getSoundType(state, (LevelReader)world, pos, (Entity)player);
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, stepSound.getStepSound(), SoundSource.BLOCKS, (stepSound.getVolume() + 1.0f) / 2.0f, stepSound.getPitch() * 0.8f);
        if (!world.isClientSide) {
            world.setBlockAndUpdate(pos, farmland.defaultBlockState());
            ElectricItem.manager.use(stack, this.operationEnergyCost, (LivingEntity)player);
        }
        return InteractionResult.SUCCESS;
    }
}

