/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.api.item.energy.EnergyItem;
import com.denfop.items.energy.ItemToolIU;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.ModUtils;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public abstract class ItemEnergyTool
extends ItemToolIU
implements EnergyItem {
    public final int operationEnergyCost;
    public int maxCharge;
    public int transferLimit;
    public int tier;
    private String nameItem;

    public ItemEnergyTool(int operationEnergyCost) {
        this(2.0f, -3.0f, operationEnergyCost, (TagKey<Block>)Tags.Blocks.GLASS_BLOCKS);
    }

    public ItemEnergyTool(float damage, float speed, int operationEnergyCost, TagKey<Block> mineableBlocks) {
        super(mineableBlocks, new Item.Properties().stacksTo(1).setNoRepair());
        this.operationEnergyCost = operationEnergyCost;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }

    @Override
    public void inventoryTick(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public float getDestroySpeed(ItemStack p_41004_, BlockState p_41005_) {
        return !ElectricItem.manager.canUse(p_41004_, this.operationEnergyCost) ? 0.1f : super.getDestroySpeed(p_41004_, p_41005_);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity user) {
        if (state.getDestroySpeed((BlockGetter)world, pos) != 0.0f) {
            ElectricItem.manager.use(stack, this.operationEnergyCost, user);
        }
        return true;
    }
}

