/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.crop;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.api.crop.CropNetwork;
import com.denfop.api.crop.ICrop;
import com.denfop.api.crop.ICropItem;
import com.denfop.api.crop.genetics.Genome;
import com.denfop.blocks.ISubEnum;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.IProperties;
import com.denfop.items.ItemMain;
import com.denfop.utils.Keyboard;
import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ItemCrops<T extends Enum<T>>
extends ItemMain<T>
implements ICropItem,
IProperties {
    public ItemCrops(T element) {
        super(new Item.Properties(), element);
        IUCore.proxy.addProperties(this);
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu.crops.seeds";
        }
        return this.nameItem;
    }

    @Override
    public String[] properties() {
        return new String[]{"id"};
    }

    @Override
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        ICrop crop = this.getCrop(0, itemStack);
        if (Keyboard.isKeyDown(340)) {
            return crop.getId() == 3 ? -1.0f : (float)crop.getId();
        }
        return -1.0f;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"iu.use_agriculture_analyzer").append((Component)Component.translatable((String)IUItem.agricultural_analyzer.getItem().getDescriptionId())));
        super.appendHoverText(stack, level, tooltip, flag);
        ICrop crop = this.getCrop(0, stack);
        if (crop.getId() != 3) {
            ItemStack drop;
            ItemStack soil = crop.getSoil().getStack();
            if (!soil.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"iu.crop.oneprobe.soil").append(" ").append(soil.getHoverName()).withStyle(ChatFormatting.YELLOW));
            }
            if (!crop.getDrops().isEmpty() && !(drop = crop.getDrops().get(0)).isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"iu.crop.oneprobe.drop").append(" ").append(drop.getHoverName()).withStyle(ChatFormatting.AQUA));
            }
            if (!crop.getCropCombine().isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"iu.crop.breeding").withStyle(ChatFormatting.GREEN));
                for (ICrop crop1 : crop.getCropCombine()) {
                    tooltip.add((Component)Component.translatable((String)("crop." + crop1.getName())));
                }
            }
        }
    }

    public Component getName(ItemStack stack) {
        ICrop crop = CropNetwork.instance.getCrop((Integer)stack.getOrDefault(DataComponentsInit.CROP, (Object)0));
        return Component.translatable((String)super.getDescriptionId(stack)).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("crop." + crop.getName())));
    }

    @Override
    public ICrop getCrop(int meta, ItemStack stack) {
        return CropNetwork.instance.getCrop((Integer)stack.getOrDefault(DataComponentsInit.CROP, (Object)0));
    }

    public ItemStack getCrop(int meta) {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(DataComponentsInit.CROP, (Object)meta);
        new Genome(stack);
        return stack;
    }

    @Override
    public void fillItemCategory(CreativeModeTab tab, NonNullList<ItemStack> items) {
        if (this.allowedIn(tab)) {
            CropNetwork.instance.getCropMap().forEach((id, crop) -> {
                if (id != 3) {
                    ItemStack stack = new ItemStack((ItemLike)this);
                    stack.set(DataComponentsInit.CROP, id);
                    new Genome(stack);
                    items.add((Object)stack);
                }
            });
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.CropsTab;
    }

    public static enum Types implements ISubEnum
    {
        crop;

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        private Types() {
            this.ID = this.ordinal();
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "crops";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

