/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour.special;

import com.denfop.IUCore;
import com.denfop.api.widget.ButtonListSliderWidget;
import com.denfop.api.widget.SliderWidget;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.items.armour.special.ContainerMenuStreak;
import com.denfop.network.packet.PacketColorPicker;
import com.denfop.render.streak.PlayerStreakInfo;
import com.denfop.render.streak.RGB;
import com.denfop.screen.ScreenMain;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ScreenColorPicker<T extends ContainerMenuBase<?>>
extends ScreenMain<ContainerMenuStreak>
implements ButtonListSliderWidget.GuiResponder,
SliderWidget.FormatHelper {
    private final ResourceLocation background = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/Color.png".toLowerCase());
    boolean isRgb = false;
    private PlayerStreakInfo colorPicker;
    private Checkbox rgb;

    public ScreenColorPicker(ContainerMenuStreak container, ItemStack itemStack1) {
        super(container);
        this.componentList.clear();
    }

    public Component getTitle() {
        return Component.literal((String)"");
    }

    protected void init() {
        super.init();
        this.colorPicker = IUCore.mapStreakInfo.get(((ContainerMenuStreak)this.container).player.getName().getString());
        if (this.colorPicker == null) {
            this.colorPicker = new PlayerStreakInfo(new RGB(0, 0, 0), false);
            IUCore.mapStreakInfo.put(((ContainerMenuStreak)this.container).player.getName().getString(), this.colorPicker);
            new PacketColorPicker(this.colorPicker, ((ContainerMenuStreak)this.container).player.getName().getString(), ((ContainerMenuStreak)this.container).player.registryAccess());
        }
        this.renderables.add(new SliderWidget(this, 0, (this.width - this.imageWidth) / 2 + 10, (this.height - this.imageHeight) / 2 + 80, Localization.translate("iu.red"), 0.0f, 255.0f, this.colorPicker.getRgb().getRed(), this));
        this.renderables.add(new SliderWidget(this, 1, (this.width - this.imageWidth) / 2 + 10, (this.height - this.imageHeight) / 2 + 110, Localization.translate("iu.green"), 0.0f, 255.0f, this.colorPicker.getRgb().getGreen(), this));
        this.renderables.add(new SliderWidget(this, 2, (this.width - this.imageWidth) / 2 + 10, (this.height - this.imageHeight) / 2 + 140, Localization.translate("iu.blue"), 0.0f, 255.0f, this.colorPicker.getRgb().getBlue(), this));
        this.rgb = Checkbox.builder((Component)Component.translatable((String)"iu.rgb"), (Font)Minecraft.getInstance().font).pos((this.width - this.imageWidth) / 2 + 10, (this.height - this.imageHeight) / 2 + 155).maxWidth(20).selected(this.colorPicker.isRainbow()).build();
        this.isRgb = this.colorPicker.isRainbow();
        this.renderables.add(this.rgb);
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
    }

    @Override
    public void setEntryValue(int id, boolean value) {
    }

    @Override
    public void setEntryValue(int id, float value) {
        switch (id) {
            case 0: {
                this.colorPicker.getRgb().setRed((short)value);
                break;
            }
            case 1: {
                this.colorPicker.getRgb().setGreen((short)value);
                break;
            }
            case 2: {
                this.colorPicker.getRgb().setBlue((short)value);
            }
        }
        new PacketColorPicker(this.colorPicker, ((ContainerMenuStreak)this.container).player.getName().getString(), ((ContainerMenuStreak)this.container).player.registryAccess());
    }

    @Override
    public void setEntryValue(int id, @Nonnull String value) {
    }

    public void drawTexturedModalRect1(PoseStack poseStack, int x, int y, int textureX, int textureY, int width, int height) {
        double[] name = new double[3];
        for (int i = 0; i < 3; ++i) {
            if (!(this.renderables.get(i) instanceof SliderWidget)) continue;
            SliderWidget slider = (SliderWidget)((Object)this.renderables.get(i));
            name[i] = slider.getSliderValue();
        }
        Tesselator tessellator = Tesselator.getInstance();
        this.bindTexture();
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        Matrix4f matrix4f = poseStack.last().pose();
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        bufferbuilder.addVertex(matrix4f, (float)x, (float)(y + height), 0.0f).setUv((float)textureX * 0.00390625f, (float)(textureY + height) * 0.00390625f).setColor((float)name[0] / 255.0f, (float)name[1] / 255.0f, (float)name[2] / 255.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, (float)x + (float)width, (float)(y + height), 0.0f).setUv((float)(textureX + width) * 0.00390625f, (float)(textureY + height) * 0.00390625f).setColor((float)name[0] / 255.0f, (float)name[1] / 255.0f, (float)name[2] / 255.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, (float)x + (float)width, (float)y, 0.0f).setUv((float)(textureX + width) * 0.00390625f, (float)textureY * 0.00390625f).setColor((float)name[0] / 255.0f, (float)name[1] / 255.0f, (float)name[2] / 255.0f, 1.0f);
        bufferbuilder.addVertex(matrix4f, (float)x, (float)y, 0.0f).setUv((float)textureX * 0.00390625f, (float)textureY * 0.00390625f).setColor((float)name[0] / 255.0f, (float)name[1] / 255.0f, (float)name[2] / 255.0f, 1.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int xOffset = this.guiLeft;
        int yOffset = this.guiTop;
        ScreenColorPicker.bindTexture(this.background);
        this.drawTexturedModalRect1(poseStack.pose(), xOffset, yOffset, 15, 1, 180, 60);
        if (this.isRgb != this.rgb.selected()) {
            this.isRgb = this.rgb.selected();
            this.colorPicker.setRainbow(this.isRgb);
            new PacketColorPicker(this.colorPicker, ((ContainerMenuStreak)this.container).player.getName().getString(), ((ContainerMenuStreak)this.container).player.registryAccess());
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        super.mouseClicked(i, j, k);
        int xMin = (this.width - this.imageWidth) / 2;
        int yMin = (this.height - this.imageHeight) / 2;
        int x = i - xMin;
        int y = j - yMin;
    }

    @Override
    @Nonnull
    public String getText(int id, @Nonnull String name, float value) {
        switch (id) {
            case 0: {
                return Localization.translate("iu.red") + (int)value;
            }
            case 1: {
                return Localization.translate("iu.green") + (int)value;
            }
            case 2: {
                return Localization.translate("iu.blue") + (int)value;
            }
        }
        return "";
    }

    protected void drawBackgroundAndTitle(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.background;
    }
}

