/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour.special;

import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.armour.special.ContainerMenuLegsBags;
import com.denfop.items.armour.special.ScreenLegsBags;
import com.denfop.items.bags.BagsDescription;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ElectricItem;
import java.util.ArrayList;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemStackLegsBags
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    private final double coef;

    public ItemStackLegsBags(Player player, ItemStack stack) {
        super(player, stack, 45);
        this.inventorySize = 45;
        this.itemStack1 = stack;
        this.coef = 1.0 - (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.ENERGY, stack) ? (double)UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.ENERGY, (ItemStack)stack).number * 0.25 : 0.0);
        this.updatelist();
    }

    public ContainerMenuBase<ItemStackLegsBags> getGuiContainer(Player player) {
        return new ContainerMenuLegsBags(player, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player player, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenLegsBags((ContainerMenuLegsBags)isAdmin, this.itemStack1);
    }

    @Override
    public void setItem(int slot, ItemStack stack) {
        super.setItem(slot, stack);
        this.updatelist();
    }

    private void updatelist() {
        ArrayList<BagsDescription> list = new ArrayList<BagsDescription>();
        for (ItemStack stack : this.inventory) {
            if (stack == null || stack.isEmpty()) continue;
            if (list.isEmpty()) {
                list.add(new BagsDescription(stack));
                continue;
            }
            if (list.contains(new BagsDescription(stack))) {
                for (BagsDescription bagsDescription : list) {
                    if (!bagsDescription.equals(new BagsDescription(stack))) continue;
                    bagsDescription.addCount(stack.getCount());
                }
                continue;
            }
            list.add(new BagsDescription(stack));
        }
        this.itemStack1.set(DataComponentsInit.DESCRIPTIONS_CONTAINER, list);
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        if (ElectricItem.manager.canUse(this.itemStack1, 50.0 * this.coef)) {
            return !itemstack.isEmpty();
        }
        return false;
    }
}

