/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.api.item.energy.EnergyItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorBase;
import com.denfop.register.Register;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.ModUtils;
import net.minecraft.core.Holder;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class ItemArmorEnergy
extends ItemArmorBase
implements ISpecialArmor,
EnergyItem {
    protected final double maxCharge;
    protected final double transferLimit;
    protected final int tier;

    public ItemArmorEnergy(String armorName, ArmorItem.Type armorType, double maxCharge, double transferLimit, int tier) {
        super((Holder<ArmorMaterial>)Register.ENERGY_ITEM, armorName, armorType);
        this.maxCharge = maxCharge;
        this.tier = tier;
        this.transferLimit = transferLimit;
    }

    @Override
    public void inventoryTick(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(p_41404_, p_41405_, p_41406_, p_41407_, p_41408_);
        if (!p_41404_.has(DataComponentsInit.ENERGY)) {
            p_41404_.set(DataComponentsInit.ENERGY, (Object)0.0);
        }
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @NotNull ItemStack armor, DamageSource source, double damage, int slot) {
        if (source.is(DamageTypeTags.BYPASSES_ARMOR)) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double absorptionRatio = this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio();
        int energyPerDamage = this.getEnergyPerDamage();
        int damageLimit = Integer.MAX_VALUE;
        if (energyPerDamage > 0) {
            damageLimit = (int)Math.min((double)damageLimit, 25.0 * ElectricItem.manager.getCharge(armor) / (double)energyPerDamage);
        }
        return new ISpecialArmor.ArmorProperties(0, absorptionRatio, damageLimit);
    }

    @Override
    public int getArmorDisplay(Player player, ItemStack armor, int slot) {
        return ElectricItem.manager.getCharge(armor) >= (double)this.getEnergyPerDamage() ? (int)Math.round(20.0 * this.getBaseAbsorptionRatio() * this.getDamageAbsorptionRatio()) : 0;
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    @Override
    public void damageArmor(LivingEntity entity, ItemStack stack, DamageSource source, float damage, int slot) {
        ElectricItem.manager.discharge(stack, damage * (float)this.getEnergyPerDamage(), Integer.MAX_VALUE, true, false, false);
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxCharge;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferLimit;
    }

    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public abstract double getDamageAbsorptionRatio();

    public abstract int getEnergyPerDamage();

    protected final double getBaseAbsorptionRatio() {
        switch (this.getEquipmentSlot()) {
            case HEAD: 
            case FEET: {
                return 0.15;
            }
            case CHEST: {
                return 0.4;
            }
            case LEGS: {
                return 0.3;
            }
        }
        return 0.0;
    }
}

