/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.armour;

import com.denfop.IUCore;
import com.denfop.api.item.energy.EnergyItem;
import com.denfop.api.item.upgrade.EnumUpgrades;
import com.denfop.api.item.upgrade.UpgradeItem;
import com.denfop.api.item.upgrade.UpgradeSystem;
import com.denfop.api.item.upgrade.event.EventItemLoad;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.armour.ISpecialArmor;
import com.denfop.items.armour.ItemArmorEnergy;
import com.denfop.sound.EnumSound;
import com.denfop.sound.SoundHandler;
import com.denfop.utils.ElectricItem;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.KeyboardIU;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;

public class ItemAdvJetpack
extends ItemArmorEnergy
implements EnergyItem,
ISpecialArmor,
IProperties,
UpgradeItem {
    private static boolean lastJetpackUsed = false;
    private final String armorName;
    private final double maxStorage;
    private final double TransferLimit;
    private final int tier;

    public ItemAdvJetpack(String name, double maxStorage, double TransferLimit, int tier) {
        super("", ArmorItem.Type.CHESTPLATE, maxStorage, TransferLimit, tier);
        this.armorName = name;
        this.maxStorage = maxStorage;
        this.TransferLimit = TransferLimit;
        this.tier = tier;
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.JETPACK.list));
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ItemStack var4 = new ItemStack((ItemLike)this, 1);
            ElectricItem.manager.charge(var4, 2.147483647E9, Integer.MAX_VALUE, true, false);
            p_41392_.add((Object)var4);
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString().split("\\.")[2] + ".name";
        }
        return this.nameItem;
    }

    @Override
    public String[] properties() {
        return new String[]{"", "Demon", "Dark", "Cold", "Ender"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        CompoundTag nbt = ModUtils.nbt(stack);
        return nbt.getString("mode").equals(property) ? 1.0f : 0.0f;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level worldIn, Entity p_41406_, int p_41407_, boolean p_41408_) {
        super.inventoryTick(stack, worldIn, p_41406_, p_41407_, p_41408_);
        if (!UpgradeSystem.system.hasInMap(stack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(worldIn, this, stack));
        }
        if (p_41407_ >= 36 && p_41407_ < 40 && p_41406_ instanceof Player) {
            Player player = (Player)p_41406_;
            this.onArmorTick(stack, worldIn, (Player)p_41406_);
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext p_41422_, List<Component> tooltip, TooltipFlag p_41424_) {
        super.appendHoverText(stack, p_41422_, tooltip, p_41424_);
        if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, stack)) {
            tooltip.add((Component)Component.literal((String)(Localization.translate("iu.fly") + " " + ModUtils.Boolean((Boolean)stack.getOrDefault(DataComponentsInit.JETPACK, (Object)false)))));
            tooltip.add((Component)Component.literal((String)Localization.translate("iu.fly_need")));
            if (!KeyboardIU.isKeyDown(340)) {
                tooltip.add((Component)Component.literal((String)Localization.translate("press.lshift")));
            }
            if (KeyboardIU.isKeyDown(340)) {
                tooltip.add((Component)Component.literal((String)(Localization.translate("iu.changemode_fly") + KeyboardClient.flymode.getKey().getDisplayName().getString())));
            }
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        int prev = this.getDamage(stack);
    }

    @Override
    public double getDamageAbsorptionRatio() {
        return 0.4;
    }

    @Override
    public int getEnergyPerDamage() {
        return 20000;
    }

    @Override
    @Nullable
    public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
        int suffix = this.getEquipmentSlot() == EquipmentSlot.LEGS ? 2 : 1;
        CompoundTag nbtData = ModUtils.nbt(stack);
        if (!nbtData.getString("mode").isEmpty()) {
            return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.armorName + "_" + nbtData.getString("mode") + "_" + suffix + ".png"));
        }
        return ResourceLocation.parse((String)("industrialupgrade:textures/armor/" + this.armorName + "_" + suffix + ".png"));
    }

    public double getCharge(ItemStack itemStack) {
        return ElectricItem.manager.getCharge(itemStack);
    }

    public void use(ItemStack itemStack, double amount) {
        ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false, false);
    }

    public boolean useJetpack(Player player, boolean hoverMode) {
        ItemStack jetpack = (ItemStack)player.getInventory().armor.get(2);
        if (this.getCharge(jetpack) <= 0.0) {
            return false;
        }
        boolean electric = true;
        float power = 1.0f;
        float dropPercentage = 0.2f;
        power = 0.7f;
        dropPercentage = 0.05f;
        if (this.getCharge(jetpack) / this.getMaxEnergy(jetpack) <= (double)dropPercentage) {
            power = (float)((double)power * (this.getCharge(jetpack) / (this.getMaxEnergy(jetpack) * (double)dropPercentage)));
        }
        if (IUCore.keyboard.isForwardKeyDown(player)) {
            float forwardpower;
            float retruster = 0.15f;
            if (hoverMode) {
                retruster = 1.0f;
            }
            if (electric) {
                retruster += 0.15f;
            }
            if ((forwardpower = power * retruster * 2.0f) > 0.0f) {
                player.moveRelative(0.0f, new Vec3(0.0, (double)(0.4f * forwardpower), (double)0.02f));
            }
        }
        int worldHeight = player.level().getHeight();
        int maxFlightHeight = electric ? (int)((float)worldHeight / 1.28f) : worldHeight;
        double y = player.getY();
        if (y > (double)(maxFlightHeight - 25)) {
            if (y > (double)maxFlightHeight) {
                y = maxFlightHeight;
            }
            power = (float)((double)power * (((double)maxFlightHeight - y) / 25.0));
        }
        Vec3 affectedMotion = player.getDeltaMovement();
        double prevmotion = affectedMotion.y;
        double moveY = Math.min(affectedMotion.y + (double)(power * 0.2f), (double)0.6f);
        player.setDeltaMovement(affectedMotion.x, moveY, affectedMotion.z);
        if (hoverMode) {
            float maxHoverY = 0.0f;
            if (IUCore.keyboard.isJumpKeyDown(player)) {
                maxHoverY = electric ? 0.1f : 0.2f;
            }
            if (IUCore.keyboard.isSneakKeyDown(player)) {
                maxHoverY = electric ? -0.1f : -0.2f;
            }
            if (moveY > (double)maxHoverY) {
                moveY = maxHoverY;
                if (prevmotion > moveY) {
                    moveY = prevmotion;
                }
                player.setDeltaMovement(affectedMotion.x, moveY, affectedMotion.z);
            }
        }
        int consume = 2;
        if (hoverMode) {
            consume = 1;
        }
        if (electric) {
            consume += 6;
        }
        if (!player.onGround()) {
            this.use(jetpack, consume);
        }
        player.fallDistance = 0.0f;
        player.walkDist = 0.0f;
        return true;
    }

    @Override
    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return this.maxStorage;
    }

    @Override
    public short getTierItem(ItemStack itemStack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack itemStack) {
        return this.TransferLimit;
    }

    public void onArmorTick(@Nonnull ItemStack itemStack, @Nonnull Level world, Player player) {
        if (((ItemStack)player.getInventory().armor.get(2)).is(itemStack.getItem())) {
            int resistance;
            boolean fireResistance;
            CompoundTag nbtData = ModUtils.nbt(itemStack);
            boolean hoverMode = nbtData.getBoolean("hoverMode");
            byte toggleTimer = nbtData.getByte("toggleTimer");
            boolean jetpackUsed = false;
            if (IUCore.keyboard.isJumpKeyDown(player) && IUCore.keyboard.isVerticalMode(player) && toggleTimer == 0) {
                toggleTimer = 10;
                boolean bl = hoverMode = !hoverMode;
                if (!player.level().isClientSide()) {
                    nbtData.putBoolean("hoverMode", hoverMode);
                    if (hoverMode) {
                        IUCore.proxy.messagePlayer(player, "Hover Mode enabled.");
                    } else {
                        IUCore.proxy.messagePlayer(player, "Hover Mode disabled.");
                    }
                }
            }
            if (((Boolean)itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)false)).booleanValue()) {
                player.fallDistance = 0.0f;
                if (nbtData.getBoolean("jump") && !((Boolean)itemStack.getOrDefault(DataComponentsInit.FLY, (Object)false)).booleanValue() && !player.getAbilities().mayfly && IUCore.keyboard.isJumpKeyDown(player) && toggleTimer == 0) {
                    toggleTimer = 10;
                    itemStack.set(DataComponentsInit.JETPACK, (Object)true);
                }
                nbtData.putBoolean("jump", !player.onGround());
                if (!player.onGround()) {
                    if (ElectricItem.manager.canUse(itemStack, 25.0)) {
                        ElectricItem.manager.use(itemStack, 25.0, null);
                    } else {
                        itemStack.set(DataComponentsInit.JETPACK, (Object)false);
                    }
                }
            }
            boolean jetpack = (Boolean)itemStack.getOrDefault(DataComponentsInit.JETPACK, (Object)false);
            if ((IUCore.keyboard.isJumpKeyDown(player) || hoverMode) && !jetpack) {
                jetpackUsed = this.useJetpack(player, hoverMode);
            }
            if (IUCore.keyboard.isFlyModeKeyDown(player) && toggleTimer == 0 && UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FLY, itemStack)) {
                toggleTimer = 10;
                boolean bl = jetpack = !jetpack;
                if (!player.level().isClientSide()) {
                    itemStack.set(DataComponentsInit.JETPACK, (Object)jetpack);
                    if (jetpack) {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info"));
                    } else {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.flymode_armor.info1"));
                    }
                }
            }
            if (!player.level().isClientSide() && toggleTimer > 0) {
                toggleTimer = (byte)(toggleTimer - 1);
                nbtData.putByte("toggleTimer", toggleTimer);
            }
            if (world.isClientSide() && player == IUCore.proxy.getPlayerInstance()) {
                if (lastJetpackUsed != jetpackUsed) {
                    if (jetpackUsed) {
                        SoundHandler.playSound(player, "JetpackLoop");
                    }
                    if (!(lastJetpackUsed = jetpackUsed)) {
                        SoundHandler.stopSound(EnumSound.JetpackLoop);
                    }
                }
                Random rnd = IUCore.random;
                Vec3 motion = player.getDeltaMovement();
                if (jetpackUsed) {
                    int i;
                    for (i = 0; i < rnd.nextInt(10); ++i) {
                        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)((float)(player.getX() - motion.x) + rnd.nextFloat()), (double)((float)player.getY()), (double)((float)(player.getZ() - motion.z) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                    }
                    for (i = 0; i < rnd.nextInt(10); ++i) {
                        world.addParticle((ParticleOptions)ParticleTypes.FLAME, (double)((float)(player.getX() - motion.x) + rnd.nextFloat()), (double)((float)player.getY()), (double)((float)(player.getZ() - motion.z) + rnd.nextFloat()), 0.0, -0.25, 0.0);
                    }
                }
            }
            if (fireResistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.FIRE_PROTECTION, itemStack)) {
                player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 300));
            }
            int n = resistance = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.RESISTANCE, itemStack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.RESISTANCE, (ItemStack)itemStack).number : 0;
            if (resistance != 0) {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 300, resistance));
            }
            if (UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.INVISIBILITY, itemStack)) {
                player.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 300));
            }
            if (jetpackUsed) {
                player.containerMenu.broadcastChanges();
            }
        }
    }

    @Override
    public boolean getIsRepairable(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    @Override
    public ISpecialArmor.ArmorProperties getProperties(LivingEntity player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    @Override
    public int getArmorDisplay(Player player, @Nonnull ItemStack armor, int slot) {
        return 0;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.JETPACK.list;
    }
}

